/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.setup;

import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetup;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ComparisonSetupWizardPage
extends WizardPage {
    protected final ComparisonSetup _setup;

    public ComparisonSetupWizardPage(String name_p, ComparisonSetup setup_p) {
        super(name_p);
        this._setup = setup_p;
        if (this._setup.getSelectedFactory() == null) {
            this._setup.setSelectedFactoryToLast();
        }
    }

    public void createControl(Composite parent_p) {
        this.setTitle(Messages.ComparisonSetupWizardPage_Title);
        this.setDescription(Messages.ComparisonSetupWizardPage_Description);
        Composite composite = new Composite(parent_p, 0);
        this.setControl((Control)composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createRolesSection(composite);
        this.createComparisonMethodSection(composite);
        this._setup.swapScopeDefinitions(Role.TARGET, Role.TARGET);
        Point size = composite.computeSize(-1, -1);
        ((GridData)parent_p.getLayoutData()).heightHint = size.y + 5;
    }

    protected void createComparisonMethodSection(Composite parent_p) {
        Group group = new Group(parent_p, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.ComparisonSetupWizardPage_GroupMethod);
        ComboViewer methodViewer = this.createComparisonMethodViewer((Composite)group);
        this.createConfigureMethodButton((Composite)group);
        methodViewer.setInput((Object)this._setup);
        Object toSelect = this._setup.getSelectedFactory();
        if (toSelect == null) {
            toSelect = methodViewer.getElementAt(0);
        }
        StructuredSelection viewerSelection = toSelect != null ? new StructuredSelection(toSelect) : new StructuredSelection();
        methodViewer.setSelection((ISelection)viewerSelection);
    }

    protected Button createConfigureMethodButton(Composite parent_p) {
        final Button result = new Button(parent_p, 8);
        result.setText(Messages.ComparisonSetupWizardPage_ConfigureButton);
        result.setLayoutData((Object)new GridData(16384, 128, false, false));
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                IComparisonMethod method = ComparisonSetupWizardPage.this._setup.getComparisonMethod();
                if (method != null) {
                    method.configure();
                }
            }
        });
        this._setup.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("ComparisonSetup.Property.ComparisonMethod".equals(event_p.getProperty())) {
                    IComparisonMethod method = ComparisonSetupWizardPage.this._setup.getComparisonMethod();
                    result.setEnabled(method != null && method.isConfigurable());
                }
            }
        });
        return result;
    }

    protected ComboViewer createComparisonMethodViewer(Composite parent_p) {
        ComboViewer result = new ComboViewer(parent_p);
        result.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        result.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement_p) {
                Object[] localResult = new Object[]{};
                if (inputElement_p instanceof ComparisonSetup) {
                    ComparisonSetup selection = (ComparisonSetup)inputElement_p;
                    localResult = selection.getApplicableComparisonMethodFactories().toArray();
                }
                return localResult;
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element_p) {
                String localResult;
                if (element_p instanceof IComparisonMethodFactory) {
                    IComparisonMethodFactory factory = (IComparisonMethodFactory)element_p;
                    localResult = factory.getLabel();
                } else {
                    localResult = super.getText(element_p);
                }
                return localResult;
            }
        });
        result.setComparator(new ViewerComparator());
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                Object selected;
                ISelection selection = event_p.getSelection();
                if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof IComparisonMethodFactory) {
                    ComparisonSetupWizardPage.this._setup.setSelectedFactory((IComparisonMethodFactory)selected);
                }
            }
        });
        return result;
    }

    protected void createRolesSection(Composite parent_p) {
        Group group = new Group(parent_p, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(Messages.ComparisonSetupWizardPage_GroupRoles);
        this.createRolesSubsection((Composite)group);
        this.createSwapRolesSubsection((Composite)group);
        this.createTargetSideSubsection((Composite)group);
    }

    protected void createRoleSubsection(Composite parent_p, final ComparisonSetup.Side side_p) {
        boolean isAncestor;
        boolean bl = isAncestor = side_p == ComparisonSetup.Side.ANCESTOR;
        String labelText = isAncestor ? Messages.ComparisonSetupWizardPage_RoleAncestor : (side_p == ComparisonSetup.Side.LEFT ? Messages.ComparisonSetupWizardPage_RoleLeft : Messages.ComparisonSetupWizardPage_RoleRight);
        new Label(parent_p, 0).setText(labelText);
        Composite composite = new Composite(parent_p, 2048);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        final Text roleText = new Text(composite, 8);
        roleText.setLayoutData((Object)new GridData(4, 4, true, false));
        this._setup.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("ComparisonSetup.Property.Roles".equals(event_p.getProperty())) {
                    Role role = ComparisonSetupWizardPage.this._setup.getRoleForSide(side_p);
                    IModelScopeDefinition scope = ComparisonSetupWizardPage.this._setup.getScopeDefinition(role);
                    roleText.setText(scope.getLabel());
                }
            }
        });
        final Button editableButton = new Button(composite, 32);
        editableButton.setText(Messages.ComparisonSetupWizardPage_ModifiableScope);
        editableButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Role role = this._setup.getRoleForSide(side_p);
        IModelScopeDefinition scopeDef = this._setup.getScopeDefinition(role);
        Role targetRole = this._setup.getRoleForSide(this._setup.getTargetSide());
        boolean isTargetOpposite = targetRole != null && targetRole.opposite() == role;
        editableButton.setEnabled(!isAncestor && !isTargetOpposite && scopeDef.isEditableSettable());
        editableButton.setSelection(scopeDef.isEditable());
        editableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                IModelScopeDefinition currentScopeDef;
                Role currentRole = ComparisonSetupWizardPage.this._setup.getRoleForSide(side_p);
                currentScopeDef.setEditable(!(currentScopeDef = ComparisonSetupWizardPage.this._setup.getScopeDefinition(currentRole)).isEditable());
            }
        });
        this._setup.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("ComparisonSetup.Property.Roles".equals(event_p.getProperty())) {
                    Role currentRole = ComparisonSetupWizardPage.this._setup.getRoleForSide(side_p);
                    IModelScopeDefinition currentScopeDef = ComparisonSetupWizardPage.this._setup.getScopeDefinition(currentRole);
                    Role currentTargetRole = ComparisonSetupWizardPage.this._setup.getRoleForSide(ComparisonSetupWizardPage.this._setup.getTargetSide());
                    boolean currentIsTargetOpposite = currentTargetRole != null && currentTargetRole.opposite() == currentRole;
                    editableButton.setEnabled(!isAncestor && !currentIsTargetOpposite && currentScopeDef.isEditableSettable());
                    editableButton.setSelection(currentScopeDef.isEditable());
                }
            }
        });
    }

    protected void createRolesSubsection(Composite parent_p) {
        Composite subsection = new Composite(parent_p, 0);
        subsection.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout rolesLayout = new GridLayout(2, false);
        rolesLayout.marginHeight = 0;
        rolesLayout.marginWidth = 0;
        subsection.setLayout((Layout)rolesLayout);
        this.createRoleSubsection(subsection, ComparisonSetup.Side.LEFT);
        this.createRoleSubsection(subsection, ComparisonSetup.Side.RIGHT);
        if (this._setup.isThreeWay()) {
            this.createRoleSubsection(subsection, ComparisonSetup.Side.ANCESTOR);
        }
    }

    protected void createSwapRolesSubsection(Composite parent_p) {
        Composite buttonSubsection = new Composite(parent_p, 0);
        buttonSubsection.setLayoutData((Object)new GridData(131072, 4, false, false));
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.justify = true;
        buttonSubsection.setLayout((Layout)buttonLayout);
        if (this._setup.canSwapScopeDefinitions()) {
            Button leftRightSwap = new Button(buttonSubsection, 8);
            leftRightSwap.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SWAP));
            leftRightSwap.setToolTipText(Messages.ComparisonSetupWizardPage_SwapLeftRight);
            leftRightSwap.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event_p) {
                    ComparisonSetupWizardPage.this._setup.swapScopeDefinitions(Role.TARGET, Role.REFERENCE);
                }
            });
            if (this._setup.isThreeWay()) {
                Button rightAnSwap = new Button(buttonSubsection, 8);
                rightAnSwap.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SWAP));
                rightAnSwap.setToolTipText(Messages.ComparisonSetupWizardPage_SwapRightAncestor);
                rightAnSwap.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event_p) {
                        ComparisonSetupWizardPage.this._setup.swapScopeDefinitions(ComparisonSetupWizardPage.this._setup.getLeftRole().opposite(), Role.ANCESTOR);
                    }
                });
            }
        }
    }

    protected void createTargetSideSubsection(Composite parent_p) {
        if (this._setup.getScopeDefinition(Role.TARGET).isEditableSettable() && this._setup.getScopeDefinition(Role.REFERENCE).isEditableSettable()) {
            Composite composite = new Composite(parent_p, 0);
            GridData gridData = new GridData(4, 128, true, true);
            composite.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginTop = 2;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(Messages.ComparisonSetupWizardPage_ReferenceRole);
            label.setToolTipText(Messages.ComparisonSetupWizardPage_ReferenceRoleTooltip);
            final Button noneButton = new Button(composite, 16);
            noneButton.setText(Messages.ComparisonSetupWizardPage_ReferenceNone);
            noneButton.setSelection(this._setup.getTargetSide() == null);
            noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e_p) {
                    if (noneButton.getSelection()) {
                        ComparisonSetupWizardPage.this._setup.setTargetSide(null);
                    }
                }
            });
            noneButton.setEnabled(noneButton.getSelection() || this._setup.canChangeTargetSide());
            final Button leftButton = new Button(composite, 16);
            leftButton.setText(Messages.ComparisonSetupWizardPage_ReferenceLeft);
            leftButton.setSelection(this._setup.getTargetSide() == ComparisonSetup.Side.LEFT);
            leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e_p) {
                    if (leftButton.getSelection()) {
                        ComparisonSetupWizardPage.this._setup.setTargetSide(ComparisonSetup.Side.LEFT);
                    }
                }
            });
            leftButton.setEnabled(leftButton.getSelection() || this._setup.canChangeTargetSide());
            final Button rightButton = new Button(composite, 16);
            rightButton.setText(Messages.ComparisonSetupWizardPage_ReferenceRight);
            rightButton.setSelection(this._setup.getTargetSide() == ComparisonSetup.Side.RIGHT);
            rightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e_p) {
                    if (rightButton.getSelection()) {
                        ComparisonSetupWizardPage.this._setup.setTargetSide(ComparisonSetup.Side.RIGHT);
                    }
                }
            });
            rightButton.setEnabled(rightButton.getSelection() || this._setup.canChangeTargetSide());
        }
    }
}

