/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Access implements Enumerator
{
    READ(0, "READ", "READ"),
    WRITE(1, "WRITE", "WRITE");

    public static final int READ_VALUE = 0;
    public static final int WRITE_VALUE = 1;
    private static final Access[] VALUES_ARRAY;
    public static final List<Access> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Access[]{READ, WRITE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Access get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Access result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Access getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Access result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Access get(int value) {
        switch (value) {
            case 0: {
                return READ;
            }
            case 1: {
                return WRITE;
            }
        }
        return null;
    }

    private Access(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

