/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractConfigureRemoteDialog;
import org.eclipse.egit.ui.internal.push.PushMode;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.PushResultDialog;
import org.eclipse.egit.ui.internal.push.RefSpecDialog;
import org.eclipse.egit.ui.internal.repository.SelectUriWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SimpleConfigurePushDialog
extends AbstractConfigureRemoteDialog {
    private TableViewer uriViewer;

    public static Dialog getDialog(Shell shell, Repository repository) {
        RemoteConfig configToUse = SimpleConfigurePushDialog.getConfiguredRemote(repository);
        return new SimpleConfigurePushDialog(shell, repository, configToUse, true);
    }

    public static Dialog getDialog(Shell shell, Repository repository, String remoteName) {
        RemoteConfig configToUse;
        try {
            configToUse = new RemoteConfig((Config)repository.getConfig(), remoteName);
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        return new SimpleConfigurePushDialog(shell, repository, configToUse, false);
    }

    public static RemoteConfig getConfiguredRemote(Repository repository) {
        ArrayList allRemotes;
        String branch;
        try {
            branch = repository.getBranch();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        if (branch == null) {
            return null;
        }
        String remoteName = null;
        if (!ObjectId.isId((String)branch)) {
            remoteName = repository.getConfig().getString("branch", branch, "remote");
        }
        try {
            allRemotes = RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig());
        }
        catch (URISyntaxException e) {
            allRemotes = new ArrayList();
        }
        RemoteConfig configuredConfig = null;
        RemoteConfig defaultConfig = null;
        for (RemoteConfig config : allRemotes) {
            if (remoteName != null && config.getName().equals(remoteName)) {
                configuredConfig = config;
            }
            if (!config.getName().equals("origin")) continue;
            defaultConfig = config;
        }
        if (configuredConfig != null) {
            return configuredConfig;
        }
        if (defaultConfig != null && !defaultConfig.getPushRefSpecs().isEmpty()) {
            return defaultConfig;
        }
        return null;
    }

    private SimpleConfigurePushDialog(Shell shell, Repository repository, RemoteConfig config, boolean showBranchInfo) {
        super(shell, repository, config, showBranchInfo, true);
    }

    @Override
    protected Control createAdditionalUriArea(final Composite parent) {
        ExpandableComposite pushUriArea = new ExpandableComposite(parent, 20);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pushUriArea);
        pushUriArea.setExpanded(!this.getConfig().getPushURIs().isEmpty());
        pushUriArea.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout(true, true);
                parent.getShell().pack();
            }
        });
        pushUriArea.setText(UIText.SimpleConfigurePushDialog_PushUrisLabel);
        Composite pushUriDetails = new Composite((Composite)pushUriArea, 0);
        pushUriArea.setClient((Control)pushUriDetails);
        pushUriDetails.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pushUriDetails);
        this.uriViewer = new TableViewer(pushUriDetails, 2050);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 30).applyTo((Control)this.uriViewer.getTable());
        this.uriViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Composite uriButtonArea = new Composite(pushUriDetails, 0);
        GridLayoutFactory.fillDefaults().applyTo(uriButtonArea);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)uriButtonArea);
        Button addUri = new Button(uriButtonArea, 8);
        addUri.setText(UIText.SimpleConfigurePushDialog_AddPushUriButton);
        GridDataFactory.fillDefaults().applyTo((Control)addUri);
        addUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectUriWizard wiz = new SelectUriWizard(false);
                if (new WizardDialog(SimpleConfigurePushDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    SimpleConfigurePushDialog.this.getConfig().addPushURI(wiz.getUri());
                    SimpleConfigurePushDialog.this.updateControls();
                }
            }
        });
        Button changeUri = new Button(uriButtonArea, 8);
        changeUri.setText(UIText.SimpleConfigurePushDialog_ChangePushUriButton);
        GridDataFactory.fillDefaults().applyTo((Control)changeUri);
        changeUri.setEnabled(false);
        changeUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URIish uri = (URIish)((IStructuredSelection)SimpleConfigurePushDialog.this.uriViewer.getSelection()).getFirstElement();
                SelectUriWizard wiz = new SelectUriWizard(false, uri.toPrivateString());
                if (new WizardDialog(SimpleConfigurePushDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    SimpleConfigurePushDialog.this.getConfig().removePushURI(uri);
                    SimpleConfigurePushDialog.this.getConfig().addPushURI(wiz.getUri());
                    SimpleConfigurePushDialog.this.updateControls();
                }
            }
        });
        Button deleteUri = new Button(uriButtonArea, 8);
        deleteUri.setText(UIText.SimpleConfigurePushDialog_DeletePushUriButton);
        GridDataFactory.fillDefaults().applyTo((Control)deleteUri);
        deleteUri.setEnabled(false);
        deleteUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URIish uri = (URIish)((IStructuredSelection)SimpleConfigurePushDialog.this.uriViewer.getSelection()).getFirstElement();
                SimpleConfigurePushDialog.this.getConfig().removePushURI(uri);
                SimpleConfigurePushDialog.this.updateControls();
            }
        });
        this.uriViewer.addSelectionChangedListener(event -> {
            deleteUri.setEnabled(!this.uriViewer.getSelection().isEmpty());
            changeUri.setEnabled(((IStructuredSelection)this.uriViewer.getSelection()).size() == 1);
        });
        return pushUriArea;
    }

    @Override
    protected RefSpec getNewRefSpec() {
        RefSpecDialog dlg = new RefSpecDialog(this.getShell(), this.getRepository(), this.getConfig(), true);
        return dlg.open() == 0 ? dlg.getSpec() : null;
    }

    @Override
    protected void createOkButton(Composite parent) {
        this.createButton(parent, 0, UIText.SimpleConfigurePushDialog_SaveAndPushButton, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.SimpleConfigurePushDialog_WindowTitle);
    }

    public void create() {
        super.create();
        this.setTitle(NLS.bind((String)UIText.SimpleConfigurePushDialog_DialogTitle, (Object)this.getConfig().getName()));
        this.setMessage(UIText.SimpleConfigurePushDialog_DialogMessage);
        this.updateControls();
    }

    @Override
    protected void updateControls() {
        boolean anyFetchUri = !this.getConfig().getURIs().isEmpty();
        boolean anyPushUri = !this.getConfig().getPushURIs().isEmpty();
        boolean anyUri = anyFetchUri || anyPushUri;
        this.setErrorMessage(null);
        if (!anyUri) {
            this.setErrorMessage(UIText.AbstractConfigureRemoteDialog_MissingUriMessage);
        }
        if (anyFetchUri) {
            this.commonUriText.setText(((URIish)this.getConfig().getURIs().get(0)).toPrivateString());
        } else {
            this.commonUriText.setText("");
        }
        this.uriViewer.getTable().setEnabled(anyPushUri);
        if (anyPushUri) {
            this.uriViewer.setInput((Object)this.getConfig().getPushURIs());
        } else if (anyFetchUri) {
            this.uriViewer.setInput((Object)new String[]{NLS.bind((String)UIText.SimpleConfigurePushDialog_UseUriForPushUriMessage, (Object)this.commonUriText.getText())});
        } else {
            this.uriViewer.setInput(null);
        }
        if (this.getConfig().getPushRefSpecs().isEmpty()) {
            this.specViewer.setInput((Object)new String[]{UIText.SimpleConfigurePushDialog_DefaultPushNoRefspec});
        } else {
            this.specViewer.setInput((Object)this.getConfig().getPushRefSpecs());
        }
        this.specViewer.getTable().setEnabled(!this.getConfig().getPushRefSpecs().isEmpty());
        this.addRefSpecAction.setEnabled(anyUri);
        this.addRefSpecAdvancedAction.setEnabled(anyUri);
        this.changeCommonUriAction.setEnabled(!anyPushUri);
        this.deleteCommonUriAction.setEnabled(!anyPushUri && anyUri);
        this.commonUriText.setEnabled(!anyPushUri);
        this.getButton(0).setEnabled(anyUri);
        this.getButton(98).setEnabled(anyUri);
        this.getButton(97).setEnabled(anyUri);
    }

    @Override
    protected void dryRun(IProgressMonitor monitor) {
        PushOperationUI op = new PushOperationUI(this.getRepository(), this.getConfig(), true);
        try {
            PushOperationResult result = op.execute(monitor);
            this.getShell().getDisplay().asyncExec(() -> {
                PushResultDialog dlg = new PushResultDialog(this.getShell(), this.getRepository(), result, op.getDestinationString(), true, PushMode.UPSTREAM);
                dlg.showConfigureButton(false);
                dlg.open();
            });
        }
        catch (CoreException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    @Override
    protected void performOperation() {
        PushOperationUI op = new PushOperationUI(this.getRepository(), this.getConfig().getName(), false);
        op.start();
    }
}

