/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.logconsole.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.logconsole.ILogConsole;
import org.eclipse.dltk.logconsole.ILogConsoleStream;
import org.eclipse.dltk.logconsole.ui.DefaultLogConsole;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class LogConsoleImpl
extends IOConsole {
    private final DefaultLogConsole logConsole;
    private final Map<ILogConsoleStream, IOConsoleOutputStream> streams = new HashMap<ILogConsoleStream, IOConsoleOutputStream>();

    public LogConsoleImpl(DefaultLogConsole logConsole) {
        super(logConsole.getConsoleType().computeTitle(logConsole.getIdentifier()), logConsole.getConsoleType().getType(), null, true);
        this.logConsole = logConsole;
    }

    protected void init() {
        super.init();
        this.logConsole.consoleInitialized();
    }

    public void clearConsole() {
        super.clearConsole();
        this.logConsole.clear();
    }

    protected void dispose() {
        this.logConsole.consoleDisposed();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void println(ILogConsoleStream stream, String message) throws IOException {
        IOConsoleOutputStream outputStream;
        Map<ILogConsoleStream, IOConsoleOutputStream> map = this.streams;
        synchronized (map) {
            outputStream = this.streams.get(stream);
            if (outputStream == null) {
                outputStream = this.newOutputStream();
                this.setupColor(outputStream, stream);
            }
            this.streams.put(stream, outputStream);
        }
        outputStream.write(String.valueOf(message) + "\n");
    }

    private void setupColor(IOConsoleOutputStream outputStream, ILogConsoleStream stream) {
        if (stream == ILogConsole.STDERR) {
            Display current = Display.getCurrent();
            if (current != null) {
                if (!current.isDisposed()) {
                    outputStream.setColor(current.getSystemColor(3));
                }
            } else {
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (!display.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!display.isDisposed()) {
                            outputStream.setColor(display.getSystemColor(3));
                        }
                    });
                }
            }
        }
    }
}

