/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import java.util.Arrays;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.debug.core.ILaunch;

public class RustGDBLaunchWrapper
extends GdbLaunch {
    public RustGDBLaunchWrapper(ILaunch launch) {
        super(launch.getLaunchConfiguration(), launch.getLaunchMode(), launch.getSourceLocator());
    }

    public String[] getLaunchEnvironment() throws CoreException {
        String[] envVariables = super.getLaunchEnvironment();
        int length = envVariables.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (envVariables[i].startsWith("PATH=")) {
                    int n = i;
                    envVariables[n] = String.valueOf(envVariables[n]) + ':' + RustGDBLaunchWrapper.getCargoBinLocation() + ':' + RustGDBLaunchWrapper.getGDBLocation();
                    return envVariables;
                }
                ++i;
            }
        }
        envVariables = Arrays.copyOf(envVariables, length + 1);
        envVariables[length] = "PATH=:" + RustGDBLaunchWrapper.getCargoBinLocation() + ':' + RustGDBLaunchWrapper.getGDBLocation();
        return envVariables;
    }

    private static String getCargoBinLocation() {
        IPath location = Path.fromOSString((String)CorrosionPlugin.getDefault().getPreferenceStore().getString("corrosion.rustup_cargoPath"));
        String parentDirectory = location.toFile().getParent();
        return parentDirectory != null ? parentDirectory : "";
    }

    private static String getGDBLocation() {
        IPath location = Path.fromOSString((String)CorrosionPlugin.getOutputFromCommand(Platform.getOS().equals("win32") ? "where gdb" : "which gdb"));
        String parentDirectory = location.toFile().getParent();
        return parentDirectory != null ? parentDirectory : "";
    }
}

