/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.ui.search.CSearchLabelProvider;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchViewPage;
import org.eclipse.cdt.internal.ui.search.LineSearchElement;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.jface.viewers.StyledString;

public class CSearchTreeLabelProvider
extends CSearchLabelProvider {
    public CSearchTreeLabelProvider(CSearchViewPage page) {
        super(page);
    }

    @Override
    public String getText(Object element) {
        String text = super.getText(element);
        int count = this.getMatchCount(element);
        if (count <= 1) {
            return text;
        }
        return String.valueOf(text) + " " + Messages.format(CSearchMessages.CSearchResultCollector_matches, count);
    }

    @Override
    public StyledString getStyledText(Object element) {
        if (element instanceof TranslationUnit) {
            StyledString styled = new StyledString(super.getText(element));
            int count = this.getMatchCount(element);
            if (count > 1) {
                String matchesCount = " " + Messages.format(CSearchMessages.CSearchResultCollector_matches, count);
                styled.append(matchesCount, StyledString.COUNTER_STYLER);
                return styled;
            }
        }
        if (!(element instanceof LineSearchElement)) {
            return new StyledString(this.getText(element));
        }
        LineSearchElement lineElement = (LineSearchElement)element;
        String enclosingName = "";
        ICElement enclosingElement = lineElement.getMatches()[0].getEnclosingElement();
        if (this.fPage.isShowEnclosingDefinitions() && enclosingElement != null) {
            enclosingName = String.valueOf(this.getElementDescription(enclosingElement)) + ", ";
        }
        Integer lineNumber = lineElement.getLineNumber();
        String prefix = Messages.format(CSearchMessages.CSearchResultCollector_line, enclosingName, lineNumber);
        prefix = String.valueOf(prefix) + ":  ";
        StyledString location = new StyledString(prefix, StyledString.QUALIFIER_STYLER);
        return location.append(super.getStyledText(element));
    }

    private String getElementDescription(ICElement element) {
        ICElement parent = element.getParent();
        if (parent instanceof IStructure) {
            return String.valueOf(parent.getElementName()) + "::" + element.getElementName();
        }
        return element.getElementName();
    }
}

