/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.testsrunner.internal.model.TestCase;
import org.eclipse.cdt.testsrunner.internal.model.TestItem;
import org.eclipse.cdt.testsrunner.internal.model.TestLocation;
import org.eclipse.cdt.testsrunner.internal.model.TestMessage;
import org.eclipse.cdt.testsrunner.internal.model.TestSuite;
import org.eclipse.cdt.testsrunner.model.IModelVisitor;
import org.eclipse.cdt.testsrunner.model.ITestCase;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestModelAccessor;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.eclipse.cdt.testsrunner.model.ITestSuite;
import org.eclipse.cdt.testsrunner.model.ITestingSessionListener;

public class TestModelManager
implements ITestModelUpdater,
ITestModelAccessor {
    public static final String ROOT_TEST_SUITE_NAME = "<root>";
    private Stack<TestSuite> testSuitesStack = new Stack();
    private TestCase currentTestCase = null;
    private Map<TestItem, Integer> testSuitesIndex = new HashMap<TestItem, Integer>();
    private List<ITestingSessionListener> listeners = new ArrayList<ITestingSessionListener>();
    private boolean timeMeasurement = false;
    private long testCaseStartTime = 0L;
    private TestSuiteInserter testSuiteInserter = new TestSuiteInserter();
    private TestCaseInserter testCaseInserter = new TestCaseInserter();

    public TestModelManager(ITestSuite previousTestsHierarchy, boolean timeMeasurement) {
        this.testSuitesStack.push(new TestSuite(ROOT_TEST_SUITE_NAME, null));
        if (previousTestsHierarchy != null) {
            this.timeMeasurement = false;
            previousTestsHierarchy.visit(new HierarchyCopier());
        }
        this.timeMeasurement = timeMeasurement;
        this.testSuitesIndex.clear();
    }

    public void testingStarted() {
        ITestingSessionListener[] iTestingSessionListenerArray = this.getListenersCopy();
        int n = iTestingSessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestingSessionListener listener = iTestingSessionListenerArray[n2];
            listener.testingStarted();
            ++n2;
        }
    }

    public void testingFinished() {
        this.getRootSuite().visit(new IModelVisitor(){

            @Override
            public void visit(ITestSuite testSuite) {
                List<TestItem> suiteChildren = ((TestSuite)testSuite).getChildrenList();
                Iterator<TestItem> it = suiteChildren.iterator();
                while (it.hasNext()) {
                    TestItem item = it.next();
                    if ((!(item instanceof ITestSuite) || TestModelManager.this.testSuitesIndex.containsKey(item)) && (!(item instanceof ITestCase) || item.getStatus() != ITestItem.Status.NotRun)) continue;
                    it.remove();
                }
            }

            @Override
            public void visit(ITestMessage testMessage) {
            }

            @Override
            public void visit(ITestCase testCase) {
            }

            @Override
            public void leave(ITestSuite testSuite) {
            }

            @Override
            public void leave(ITestCase testCase) {
            }

            @Override
            public void leave(ITestMessage testMessage) {
            }
        });
        this.testSuitesIndex.clear();
        ITestingSessionListener[] iTestingSessionListenerArray = this.getListenersCopy();
        int n = iTestingSessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestingSessionListener listener = iTestingSessionListenerArray[n2];
            listener.testingFinished();
            ++n2;
        }
    }

    @Override
    public void enterTestSuite(String name) {
        this.testSuiteInserter.insert(name);
    }

    @Override
    public void exitTestSuite() {
        this.exitTestCase();
        TestSuite testSuite = this.testSuitesStack.pop();
        ITestingSessionListener[] iTestingSessionListenerArray = this.getListenersCopy();
        int n = iTestingSessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestingSessionListener listener = iTestingSessionListenerArray[n2];
            listener.exitTestSuite(testSuite);
            ++n2;
        }
    }

    @Override
    public void enterTestCase(String name) {
        this.testCaseInserter.insert(name);
        if (this.timeMeasurement) {
            this.testCaseStartTime = System.currentTimeMillis();
        }
    }

    @Override
    public void setTestStatus(ITestItem.Status status) {
        this.currentTestCase.setStatus(status);
    }

    @Override
    public void setTestingTime(int testingTime) {
        this.currentTestCase.setTestingTime(testingTime);
    }

    @Override
    public void exitTestCase() {
        if (this.currentTestCase != null) {
            if (this.timeMeasurement) {
                int testingTime = (int)(System.currentTimeMillis() - this.testCaseStartTime);
                this.currentTestCase.setTestingTime(this.currentTestCase.getTestingTime() + testingTime);
                this.testCaseStartTime = 0L;
            }
            TestCase testCase = this.currentTestCase;
            this.currentTestCase = null;
            ITestingSessionListener[] iTestingSessionListenerArray = this.getListenersCopy();
            int n = iTestingSessionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestingSessionListener listener = iTestingSessionListenerArray[n2];
                listener.exitTestCase(testCase);
                ++n2;
            }
        }
    }

    @Override
    public void addTestMessage(String file, int line, ITestMessage.Level level, String text) {
        TestLocation location = file == null || file.isEmpty() || line <= 0 ? null : new TestLocation(file, line);
        this.currentTestCase.addTestMessage(new TestMessage(location, level, text));
    }

    @Override
    public ITestSuite currentTestSuite() {
        return this.testSuitesStack.peek();
    }

    @Override
    public ITestCase currentTestCase() {
        return this.currentTestCase;
    }

    @Override
    public boolean isCurrentlyRunning(ITestItem item) {
        return item == this.currentTestCase && item != null || this.testSuitesStack.contains(item);
    }

    @Override
    public TestSuite getRootSuite() {
        return (TestSuite)this.testSuitesStack.firstElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangesListener(ITestingSessionListener listener) {
        List<ITestingSessionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangesListener(ITestingSessionListener listener) {
        List<ITestingSessionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITestingSessionListener[] getListenersCopy() {
        List<ITestingSessionListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new ITestingSessionListener[this.listeners.size()]);
        }
    }

    private class HierarchyCopier
    implements IModelVisitor {
        private HierarchyCopier() {
        }

        @Override
        public void visit(ITestSuite testSuite) {
            if (testSuite.getParent() != null) {
                TestModelManager.this.enterTestSuite(testSuite.getName());
            }
        }

        @Override
        public void leave(ITestSuite testSuite) {
            if (testSuite.getParent() != null) {
                TestModelManager.this.exitTestSuite();
            }
        }

        @Override
        public void visit(ITestCase testCase) {
            TestModelManager.this.enterTestCase(testCase.getName());
            TestModelManager.this.setTestStatus(ITestItem.Status.NotRun);
        }

        @Override
        public void leave(ITestCase testCase) {
            TestModelManager.this.exitTestCase();
        }

        @Override
        public void visit(ITestMessage testMessage) {
        }

        @Override
        public void leave(ITestMessage testMessage) {
        }
    }

    private class TestCaseInserter
    extends TestItemInserter<TestCase> {
        private TestCaseInserter() {
        }

        @Override
        protected boolean isRequiredTestItemType(TestItem item) {
            return item instanceof TestCase;
        }

        @Override
        protected TestCase createTestItem(String name, TestSuite parent) {
            return new TestCase(name, parent);
        }

        @Override
        protected void addNewTestItem(TestCase testCase) {
            TestModelManager.this.currentTestCase = testCase;
            testCase.setStatus(ITestItem.Status.Skipped);
            ITestingSessionListener[] iTestingSessionListenerArray = TestModelManager.this.getListenersCopy();
            int n = iTestingSessionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestingSessionListener listener = iTestingSessionListenerArray[n2];
                listener.enterTestCase(testCase);
                ++n2;
            }
        }
    }

    private abstract class TestItemInserter<E extends TestItem> {
        private TestItemInserter() {
        }

        protected abstract boolean isRequiredTestItemType(TestItem var1);

        protected abstract E createTestItem(String var1, TestSuite var2);

        protected abstract void addNewTestItem(E var1);

        private E checkTestItem(TestItem item, String name) {
            return (E)(this.isRequiredTestItemType(item) && item.getName().equals(name) ? item : null);
        }

        private int getLastInsertIndex(TestSuite testSuite) {
            Integer intLastInsertIndex = (Integer)TestModelManager.this.testSuitesIndex.get(testSuite);
            return intLastInsertIndex != null ? intLastInsertIndex : 0;
        }

        private void notifyAboutChildrenUpdate(ITestSuite suite) {
            ITestingSessionListener[] iTestingSessionListenerArray = TestModelManager.this.getListenersCopy();
            int n = iTestingSessionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestingSessionListener listener = iTestingSessionListenerArray[n2];
                listener.childrenUpdate(suite);
                ++n2;
            }
        }

        public void insert(String name) {
            TestSuite currTestSuite = (TestSuite)TestModelManager.this.testSuitesStack.peek();
            int lastInsertIndex = this.getLastInsertIndex(currTestSuite);
            List<TestItem> children = currTestSuite.getChildrenList();
            Object newTestItem = null;
            try {
                newTestItem = this.checkTestItem(children.get(lastInsertIndex), name);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (newTestItem != null) {
                TestModelManager.this.testSuitesIndex.put(currTestSuite, lastInsertIndex + 1);
            }
            if (newTestItem == null) {
                int childIndex = lastInsertIndex;
                while (childIndex < children.size()) {
                    newTestItem = this.checkTestItem(children.get(childIndex), name);
                    if (newTestItem != null) {
                        TestModelManager.this.testSuitesIndex.put(currTestSuite, childIndex);
                        break;
                    }
                    ++childIndex;
                }
            }
            if (newTestItem == null) {
                int childIndex = 0;
                while (childIndex < lastInsertIndex) {
                    newTestItem = this.checkTestItem(children.get(childIndex), name);
                    if (newTestItem != null) {
                        TestItem removed = children.remove(childIndex);
                        lastInsertIndex = Math.min(lastInsertIndex, children.size());
                        children.add(lastInsertIndex, removed);
                        this.notifyAboutChildrenUpdate(currTestSuite);
                        break;
                    }
                    ++childIndex;
                }
            }
            if (newTestItem == null) {
                newTestItem = this.createTestItem(name, currTestSuite);
                children.add(lastInsertIndex, (TestItem)newTestItem);
                TestModelManager.this.testSuitesIndex.put(currTestSuite, lastInsertIndex + 1);
                this.notifyAboutChildrenUpdate(currTestSuite);
            }
            if (!TestModelManager.this.testSuitesIndex.containsKey(newTestItem)) {
                TestModelManager.this.testSuitesIndex.put(newTestItem, 0);
            }
            this.addNewTestItem(newTestItem);
        }
    }

    private class TestSuiteInserter
    extends TestItemInserter<TestSuite> {
        private TestSuiteInserter() {
        }

        @Override
        protected boolean isRequiredTestItemType(TestItem item) {
            return item instanceof TestSuite;
        }

        @Override
        protected TestSuite createTestItem(String name, TestSuite parent) {
            return new TestSuite(name, parent);
        }

        @Override
        protected void addNewTestItem(TestSuite testSuite) {
            TestModelManager.this.testSuitesStack.push(testSuite);
            ITestingSessionListener[] iTestingSessionListenerArray = TestModelManager.this.getListenersCopy();
            int n = iTestingSessionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestingSessionListener listener = iTestingSessionListenerArray[n2];
                listener.enterTestSuite(testSuite);
                ++n2;
            }
        }
    }
}

