/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.service.control;

import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.Messages;
import org.eclipse.cdt.dsf.gdb.internal.service.control.StepIntoSelectionActiveOperation;
import org.eclipse.cdt.dsf.mi.service.command.output.MIArg;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.osgi.util.NLS;

public class StepIntoSelectionUtils {
    public static final String cppSep = "::";

    public static boolean sameSignature(MIFrame currentFrame, StepIntoSelectionActiveOperation stepOperation) {
        String currentFunctionName = currentFrame.getFunction();
        String targetFunctionName = stepOperation.getTargetFunctionSignature();
        if (!StepIntoSelectionUtils.sameNumberOfArgumets(currentFrame, stepOperation)) {
            return false;
        }
        if (currentFunctionName.equals(targetFunctionName)) {
            return true;
        }
        String[] currentFunctTokens = currentFunctionName.split(cppSep);
        String[] targetFunctTokens = targetFunctionName.split(cppSep);
        if (currentFunctTokens.length > 1) {
            currentFunctionName = currentFunctTokens[currentFunctTokens.length - 1];
        }
        if (targetFunctTokens.length > 1) {
            targetFunctionName = targetFunctTokens[targetFunctTokens.length - 1];
        }
        return currentFunctionName.equals(targetFunctionName);
    }

    private static boolean sameNumberOfArgumets(MIFrame currentFrame, StepIntoSelectionActiveOperation stepOperation) {
        int argSizeAdjustment = 0;
        MIArg[] args = currentFrame.getArgs();
        if (args.length > 0 && args[0].getName().equals("this")) {
            argSizeAdjustment = 1;
        }
        return currentFrame.getArgs().length - argSizeAdjustment == stepOperation.getTargetFunctionDeclaration().getNumberOfParameters();
    }

    public static void missedSelectedTarget(StepIntoSelectionActiveOperation stepOperation) {
        String functionName = stepOperation.getTargetFunctionDeclaration().getElementName();
        Status status = new Status(1, "org.eclipse.cdt.dsf.gdb", 20001, String.valueOf(Messages.StepIntoSelection) + "\n" + NLS.bind((String)Messages.StepIntoSelection_Execution_did_not_enter_function, (Object)functionName), null);
        IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        if (statusHandler != null) {
            try {
                statusHandler.handleStatus((IStatus)status, null);
            }
            catch (CoreException ex) {
                GdbPlugin.getDefault().getLog().log(ex.getStatus());
            }
        }
    }
}

