/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.core.internal.util.binding.Validator;
import org.eclipse.buildship.core.internal.util.binding.Validators;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;

public final class ProjectImportConfiguration {
    private final Property<File> projectDir;
    private final Property<Boolean> overwriteWorkspaceSettings;
    private final Property<GradleDistributionViewModel> distribution;
    private final Property<File> gradleUserHome;
    private final Property<Boolean> applyWorkingSets;
    private final Property<List<String>> workingSets;
    private final Property<Boolean> buildScansEnabled;
    private final Property<Boolean> offlineMode;
    private final Property<Boolean> autoSync;

    public ProjectImportConfiguration() {
        this((Validator<File>)Validators.noOp(), (Validator<GradleDistributionViewModel>)Validators.noOp(), (Validator<File>)Validators.noOp(), (Validator<Boolean>)Validators.noOp(), (Validator<List<String>>)Validators.noOp());
    }

    public ProjectImportConfiguration(Validator<File> projectDirValidator, Validator<GradleDistributionViewModel> distributionValidator, Validator<File> gradleUserHomeValidator, Validator<Boolean> applyWorkingSetsValidator, Validator<List<String>> workingSetsValidators) {
        this.projectDir = Property.create(projectDirValidator);
        this.overwriteWorkspaceSettings = Property.create((Validator)Validators.noOp());
        this.distribution = Property.create(distributionValidator);
        this.gradleUserHome = Property.create(gradleUserHomeValidator);
        this.applyWorkingSets = Property.create(applyWorkingSetsValidator);
        this.workingSets = Property.create(workingSetsValidators);
        this.buildScansEnabled = Property.create((Validator)Validators.noOp());
        this.offlineMode = Property.create((Validator)Validators.noOp());
        this.autoSync = Property.create((Validator)Validators.noOp());
    }

    public Property<File> getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir.setValue((Object)projectDir);
    }

    public Property<Boolean> getOverrideWorkspaceConfiguration() {
        return this.overwriteWorkspaceSettings;
    }

    public void setOverwriteWorkspaceSettings(boolean overwriteWorkspaceSettings) {
        this.overwriteWorkspaceSettings.setValue((Object)overwriteWorkspaceSettings);
    }

    public Property<GradleDistributionViewModel> getDistribution() {
        return this.distribution;
    }

    public void setDistribution(GradleDistributionViewModel distribution) {
        this.distribution.setValue((Object)distribution);
    }

    public Property<File> getGradleUserHome() {
        return this.gradleUserHome;
    }

    public void setGradleUserHome(File gradleUserHome) {
        this.gradleUserHome.setValue((Object)gradleUserHome);
    }

    public Property<Boolean> getApplyWorkingSets() {
        return this.applyWorkingSets;
    }

    public void setApplyWorkingSets(Boolean applyWorkingSets) {
        this.applyWorkingSets.setValue((Object)applyWorkingSets);
    }

    public Property<List<String>> getWorkingSets() {
        return this.workingSets;
    }

    public void setWorkingSets(List<String> workingSets) {
        this.workingSets.setValue(workingSets);
    }

    public Property<Boolean> getBuildScansEnabled() {
        return this.buildScansEnabled;
    }

    public void setBuildScansEnabled(boolean buildScansEnabled) {
        this.buildScansEnabled.setValue((Object)buildScansEnabled);
    }

    public Property<Boolean> getOfflineMode() {
        return this.offlineMode;
    }

    public void setOfflineMode(boolean offlineMode) {
        this.offlineMode.setValue((Object)offlineMode);
    }

    public Property<Boolean> getAutoSync() {
        return this.autoSync;
    }

    public void setAutoSync(boolean autoSync) {
        this.autoSync.setValue((Object)autoSync);
    }

    public BuildConfiguration toInternalBuildConfiguration() {
        return CorePlugin.configurationManager().createBuildConfiguration((File)this.getProjectDir().getValue(), ((Boolean)this.getOverrideWorkspaceConfiguration().getValue()).booleanValue(), ((GradleDistributionViewModel)this.getDistribution().getValue()).toGradleDistribution(), (File)this.getGradleUserHome().getValue(), ((Boolean)this.getBuildScansEnabled().getValue()).booleanValue(), ((Boolean)this.getOfflineMode().getValue()).booleanValue(), ((Boolean)this.getAutoSync().getValue()).booleanValue());
    }

    public org.eclipse.buildship.core.BuildConfiguration toBuildConfiguration() {
        return org.eclipse.buildship.core.BuildConfiguration.forRootProjectDirectory((File)((File)this.getProjectDir().getValue())).overrideWorkspaceConfiguration(((Boolean)this.getOverrideWorkspaceConfiguration().getValue()).booleanValue()).gradleDistribution(((GradleDistributionViewModel)this.getDistribution().getValue()).toGradleDistribution()).gradleUserHome((File)this.getGradleUserHome().getValue()).buildScansEnabled(((Boolean)this.getBuildScansEnabled().getValue()).booleanValue()).offlineMode(((Boolean)this.getOfflineMode().getValue()).booleanValue()).autoSync(((Boolean)this.getAutoSync().getValue()).booleanValue()).build();
    }
}

