/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.launch;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.File;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.internal.util.binding.Validator;
import org.eclipse.buildship.core.internal.util.binding.Validators;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.core.internal.util.variable.ExpressionUtils;
import org.eclipse.buildship.ui.internal.i18n.UiMessages;
import org.eclipse.buildship.ui.internal.launch.LaunchMessages;
import org.eclipse.buildship.ui.internal.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.internal.util.font.FontUtils;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class JavaHomeTab
extends AbstractLaunchConfigurationTab {
    private final Font defaultFont = FontUtils.getDefaultDialogFont();
    private final UiBuilder.UiBuilderFactory builderFactory = new UiBuilder.UiBuilderFactory(this.defaultFont);
    private final Validator<File> javaHomeValidator = Validators.optionalDirectoryValidator((String)CoreMessages.RunConfiguration_Label_JavaHome);
    private Text javaHomeText;

    public String getName() {
        return LaunchMessages.Tab_Name_JavaHome;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        page.setLayout((Layout)layout);
        this.setControl((Control)page);
        Group javaHomeGroup = this.createGroup(page, CoreMessages.RunConfiguration_Label_JavaHome + ":");
        this.createJavaHomeSelectionControl((Composite)javaHomeGroup);
    }

    private Group createGroup(Composite parent, String groupName) {
        Group group = new Group(parent, 0);
        group.setText(groupName);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        return group;
    }

    private void createJavaHomeSelectionControl(Composite root) {
        this.javaHomeText = this.builderFactory.newText(root).alignFillHorizontal().control();
        this.javaHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JavaHomeTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button javaHomeBrowseButton = this.builderFactory.newButton(root).alignLeft().text(UiMessages.Button_Label_Browse).control();
        javaHomeBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(root.getShell(), this.javaHomeText, CoreMessages.RunConfiguration_Label_JavaHome));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        GradleRunConfigurationAttributes configurationAttributes = GradleRunConfigurationAttributes.from((ILaunchConfiguration)configuration);
        this.javaHomeText.setText(Strings.nullToEmpty((String)configurationAttributes.getJavaHomeExpression()));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        GradleRunConfigurationAttributes.applyJavaHomeExpression((String)Strings.emptyToNull((String)this.javaHomeText.getText()), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String javaHomeResolved;
        String javaHomeExpression = Strings.emptyToNull((String)this.javaHomeText.getText());
        try {
            javaHomeResolved = ExpressionUtils.decode((String)javaHomeExpression);
        }
        catch (CoreException e) {
            this.setErrorMessage(NLS.bind((String)LaunchMessages.ErrorMessage_CannotResolveExpression_0, (Object)javaHomeExpression));
            return false;
        }
        File javaHome = (File)FileUtils.getAbsoluteFile((String)javaHomeResolved).orNull();
        Optional error = this.javaHomeValidator.validate((Object)javaHome);
        this.setErrorMessage((String)error.orNull());
        return !error.isPresent();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void dispose() {
        this.defaultFont.dispose();
        super.dispose();
    }
}

