/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.util.gradle.HierarchicalElementUtils;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.GradleBuild;
import org.eclipse.buildship.core.internal.workspace.ImportRootProjectOperation;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.core.internal.workspace.ProjectConfigurators;
import org.eclipse.buildship.core.internal.workspace.RunOnImportTasksOperation;
import org.eclipse.buildship.core.internal.workspace.SynchronizeGradleBuildOperation;
import org.eclipse.buildship.core.internal.workspace.ValidateProjectLocationOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class SynchronizeGradleBuildsOperation {
    private final GradleBuild build;
    private final NewProjectHandler newProjectHandler;

    private SynchronizeGradleBuildsOperation(GradleBuild build, NewProjectHandler newProjectHandler) {
        this.build = (GradleBuild)Preconditions.checkNotNull((Object)build);
        this.newProjectHandler = (NewProjectHandler)Preconditions.checkNotNull((Object)newProjectHandler);
    }

    protected void run(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        BuildConfiguration buildConfig = this.build.getBuildConfig();
        progress.setTaskName(String.format("Synchronizing Gradle build at %s with workspace", buildConfig.getRootProjectDirectory()));
        new ImportRootProjectOperation(buildConfig, this.newProjectHandler).run((IProgressMonitor)progress.newChild(1));
        Set<EclipseProject> allProjects = this.fetchEclipseProjects(this.build, tokenSource, progress.newChild(1));
        new ValidateProjectLocationOperation(allProjects).run((IProgressMonitor)progress.newChild(1));
        new RunOnImportTasksOperation(allProjects, buildConfig).run((IProgressMonitor)progress.newChild(1), tokenSource);
        new SynchronizeGradleBuildOperation(allProjects, buildConfig, this.newProjectHandler, ProjectConfigurators.create(this.build, CorePlugin.extensionManager().loadConfigurators())).run((IProgressMonitor)progress.newChild(1));
    }

    private Set<EclipseProject> fetchEclipseProjects(GradleBuild build, CancellationTokenSource tokenSource, SubMonitor progress) {
        progress.setTaskName("Loading Gradle project models");
        ModelProvider modelProvider = build.getModelProvider();
        Collection<EclipseProject> models = modelProvider.fetchModels(EclipseProject.class, FetchStrategy.FORCE_RELOAD, tokenSource, (IProgressMonitor)progress);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (EclipseProject model : models) {
            result.addAll(HierarchicalElementUtils.getAll(model));
        }
        return result.build();
    }

    public static SynchronizeGradleBuildsOperation forSingleGradleBuild(GradleBuild build, NewProjectHandler newProjectHandler) {
        return new SynchronizeGradleBuildsOperation(build, newProjectHandler);
    }
}

