/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import java.util.Optional;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.operation.ToolingApiJobResultHandler;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.workspace.GradleClasspathContainerUpdater;
import org.eclipse.buildship.core.internal.workspace.SynchronizationJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public final class GradleClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject javaProject) throws JavaModelException {
        this.loadClasspath(javaProject);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject javaProject, IClasspathContainer containerSuggestion) throws JavaModelException {
        this.loadClasspath(javaProject);
    }

    private void loadClasspath(IJavaProject javaProject) throws JavaModelException {
        IProject project = javaProject.getProject();
        boolean updatedFromStorage = this.updateFromStorage(javaProject);
        if (!updatedFromStorage) {
            Optional<GradleBuild> gradleBuild = GradleCore.getWorkspace().getBuild(project);
            if (!gradleBuild.isPresent()) {
                GradleClasspathContainerUpdater.clear(javaProject, null);
            } else {
                SynchronizationJob job = new SynchronizationJob(gradleBuild.get());
                job.setResultHandler(new ResultHander());
                job.setUser(false);
                job.schedule();
            }
        }
    }

    private boolean updateFromStorage(IJavaProject javaProject) throws JavaModelException {
        return GradleClasspathContainerUpdater.updateFromStorage(javaProject, null);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return project;
    }

    private static final class ResultHander
    implements ToolingApiJobResultHandler<Void> {
        private ResultHander() {
        }

        @Override
        public void onSuccess(Void result) {
        }

        @Override
        public void onFailure(ToolingApiStatus status) {
            CorePlugin.getInstance().getLog().log((IStatus)status);
        }
    }
}

