/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateConnectionFeature;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.features.ICompoundCreateFeaturePart;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;
import org.eclipse.graphiti.services.Graphiti;

public class CompoundCreateFeaturePart<CONTEXT>
implements ICompoundCreateFeaturePart {
    IFeature feature;
    List<CompoundCreateFeaturePart<CONTEXT>> children = new ArrayList<CompoundCreateFeaturePart<CONTEXT>>();
    Hashtable<String, String> properties = null;
    ICompoundCreateFeaturePart parent;

    public CompoundCreateFeaturePart(ICompoundCreateFeaturePart parent, IFeature feature) {
        this.parent = parent;
        this.feature = feature;
    }

    public boolean canCreate(IContext context) {
        if (this.feature instanceof ICreateFeature && context instanceof ICreateContext) {
            if (!((ICreateFeature)this.feature).canCreate((ICreateContext)context)) {
                return false;
            }
            if (this.children.size() > 0) {
                ContainerShape parentContainer = ((ICreateContext)context).getTargetContainer();
                CreateContext childContext = new CreateContext();
                ContainerShape targetContainer = PictogramsFactory.eINSTANCE.createContainerShape();
                childContext.setTargetContainer(targetContainer);
                EClass eClass = ((AbstractBpmn2CreateFeature)this.feature).getBusinessObjectClass();
                EObject businessObject = Bpmn2Factory.eINSTANCE.create(eClass);
                PictogramLink link = PictogramsFactory.eINSTANCE.createPictogramLink();
                link.setPictogramElement((PictogramElement)targetContainer);
                link.getBusinessObjects().add((Object)businessObject);
                targetContainer.setLink(link);
                childContext.putProperty((Object)"parent.container", (Object)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)parentContainer));
                for (CompoundCreateFeaturePart<CONTEXT> child : this.children) {
                    if (child.canCreate((IContext)childContext)) continue;
                    return false;
                }
            }
        } else if (this.feature instanceof ICreateConnectionFeature && context instanceof ICreateConnectionContext && !((ICreateConnectionFeature)this.feature).canCreate((ICreateConnectionContext)context)) {
            return false;
        }
        return true;
    }

    private List<Object> create(IContext context) {
        ArrayList<Object> businessObjects = new ArrayList<Object>();
        if (this.feature instanceof ICreateFeature && context instanceof ICreateContext) {
            if (this.canCreate(context)) {
                Object[] created;
                Object[] objectArray = created = ((ICreateFeature)this.feature).create((ICreateContext)context);
                int n = created.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    businessObjects.add(o);
                    ++n2;
                }
            } else {
                Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": the object \"" + this.feature.getName() + "\" can not be created - check User Preferences."));
            }
        } else if (this.feature instanceof ICreateConnectionFeature && context instanceof ICreateConnectionContext) {
            if (this.canCreate(context)) {
                businessObjects.add(((ICreateConnectionFeature)this.feature).create((ICreateConnectionContext)context));
            } else {
                Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": the \"" + this.feature.getName() + "\" connection can not be created - check User Preferences."));
            }
        }
        BaseElement businessObject = null;
        ContainerShape targetContainer = null;
        Connection connection = null;
        for (Object e : businessObjects) {
            if (e instanceof ContainerShape && targetContainer == null) {
                targetContainer = (ContainerShape)e;
            } else if (e instanceof Connection && connection == null) {
                connection = (Connection)e;
            } else if (e instanceof BaseElement && businessObject == null) {
                businessObject = (BaseElement)e;
            }
            if (connection != null || businessObject != null && targetContainer != null) break;
        }
        if (connection != null) {
            businessObject = BusinessObjectUtil.getFirstBaseElement(connection);
        }
        this.applyBusinessObjectProperties(businessObject);
        ArrayList<PictogramElement> arrayList = new ArrayList<PictogramElement>();
        int i = 0;
        while (i < this.children.size()) {
            CompoundCreateFeaturePart<CONTEXT> node = this.children.get(i);
            node.create(context, targetContainer, arrayList, businessObjects);
            ++i;
        }
        return businessObjects;
    }

    public void create(IContext context, ContainerShape targetContainer, List<PictogramElement> pictogramElements, List<Object> businessObjects) {
        String value;
        CreateContext cc;
        CreateContext childContext = null;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (context instanceof ICreateContext) {
            ICreateContext cc2 = (ICreateContext)context;
            x = cc2.getX();
            y = cc2.getY();
            width = cc2.getWidth();
            height = cc2.getHeight();
        }
        PictogramElement source = null;
        PictogramElement target = null;
        int index = pictogramElements.size();
        if (this.feature instanceof ICreateFeature) {
            cc = new CreateContext();
            if (targetContainer == null) {
                targetContainer = ((ICreateContext)context).getTargetContainer();
            }
            cc.setTargetContainer(targetContainer);
            cc.setTargetConnection(((ICreateContext)context).getTargetConnection());
            value = this.getProperty("x");
            if (value != null) {
                x = targetContainer instanceof Diagram ? (x += Integer.parseInt(value)) : Integer.parseInt(value);
            }
            cc.setX(x);
            value = this.getProperty("y");
            if (value != null) {
                y = targetContainer instanceof Diagram ? (y += Integer.parseInt(value)) : Integer.parseInt(value);
            }
            cc.setY(y);
            value = this.getProperty("width");
            if (value != null) {
                width = Integer.parseInt(value);
            }
            cc.setWidth(width);
            value = this.getProperty("height");
            if (value != null) {
                height = Integer.parseInt(value);
            }
            cc.setHeight(height);
            value = this.getProperty("id");
            if (value != null) {
                cc.putProperty((Object)"ToolPartID", (Object)value);
            }
            childContext = cc;
        } else if (this.feature instanceof ICreateConnectionFeature) {
            String sourceId;
            cc = new CreateConnectionContext();
            value = this.getProperty("id");
            if (value != null) {
                cc.putProperty((Object)"ToolPartID", (Object)value);
            }
            if ((sourceId = this.getProperty("source")) != null) {
                for (PictogramElement pe : this.getPictogramElements()) {
                    String id = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "ToolPartID");
                    if (!sourceId.equals(id)) continue;
                    source = pe;
                    break;
                }
            } else if (index - 2 >= 0 && index - 2 < pictogramElements.size()) {
                source = pictogramElements.get(index - 2);
            }
            String targetId = this.getProperty("target");
            if (targetId != null) {
                for (PictogramElement pe : this.getPictogramElements()) {
                    String id = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "ToolPartID");
                    if (!targetId.equals(id)) continue;
                    target = pe;
                    break;
                }
            } else if (index - 1 >= 0 && index - 1 < pictogramElements.size()) {
                target = pictogramElements.get(index - 1);
            }
            if (source == null && target == null && context instanceof ICreateConnectionContext) {
                ICreateConnectionContext ccc = (ICreateConnectionContext)context;
                if (ccc.getSourceAnchor() == null) {
                    Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": source anchor is null for the \"" + this.feature.getName() + "\" connection."));
                }
                if (ccc.getTargetAnchor() == null) {
                    Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": target anchor is null for the \"" + this.feature.getName() + "\" connection."));
                }
                if (ccc.getSourcePictogramElement() == null) {
                    Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": source shape is null for the \"" + this.feature.getName() + "\" connection."));
                }
                if (ccc.getTargetPictogramElement() == null) {
                    Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": target shape is null for the \"" + this.feature.getName() + "\" connection."));
                }
                childContext = context;
            } else if (source == null) {
                Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": the source object ID \"" + sourceId + "\" can not be found for the \"" + this.feature.getName() + "\" connection."));
            } else if (target == null) {
                Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": the target object ID \"" + targetId + "\" can not be found for the \"" + this.feature.getName() + "\" connection."));
            } else {
                Point sp = GraphicsUtil.getShapeCenter((AnchorContainer)source);
                Point tp = GraphicsUtil.getShapeCenter((AnchorContainer)target);
                FixPointAnchor sourceAnchor = AnchorUtil.createAnchor((AnchorContainer)source, tp);
                FixPointAnchor targetAnchor = AnchorUtil.createAnchor((AnchorContainer)target, sp);
                cc.setSourcePictogramElement(source);
                cc.setTargetPictogramElement(target);
                cc.setSourceAnchor((Anchor)sourceAnchor);
                cc.setTargetAnchor((Anchor)targetAnchor);
                childContext = cc;
            }
        }
        List<Object> result = null;
        result = this.create((IContext)childContext);
        ContainerShape pe = null;
        Connection cn = null;
        BaseElement be = null;
        for (Object o : result) {
            if (o instanceof ContainerShape) {
                pe = (ContainerShape)o;
            } else if (o instanceof Connection) {
                cn = (Connection)o;
            } else if (o instanceof BaseElement) {
                be = (BaseElement)o;
            }
            if (cn != null || be != null && pe != null) break;
        }
        ContainerShape updatePE = null;
        if (pe != null) {
            pictogramElements.add((PictogramElement)pe);
            value = this.getProperty("ToolPartID");
            if (value == null) {
                value = (String)childContext.getProperty((Object)"ToolPartID");
            }
            if (value != null) {
                Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "ToolPartID", value);
            }
            updatePE = pe;
        } else if (cn != null) {
            be = BusinessObjectUtil.getFirstBaseElement(cn);
            value = this.getProperty("ToolPartID");
            if (value == null) {
                value = (String)childContext.getProperty((Object)"ToolPartID");
            }
            if (value != null) {
                Graphiti.getPeService().setPropertyValue((PropertyContainer)cn, "ToolPartID", value);
            }
            updatePE = cn;
        }
        if (updatePE != null) {
            this.addPictogramElement((PictogramElement)updatePE);
            UpdateContext updateContext = new UpdateContext(updatePE);
            IUpdateFeature updateFeature = this.feature.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
            if (updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) {
                updateFeature.update((IUpdateContext)updateContext);
            }
        }
        businessObjects.addAll(result);
    }

    private void applyBusinessObjectProperties(BaseElement be) {
        if (be != null && this.properties != null) {
            TargetRuntime rt = TargetRuntime.getRuntime((EObject)be);
            String className = be.eClass().getName();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                if (!entry.getKey().startsWith("$")) continue;
                String value = entry.getValue();
                if (value.startsWith("$")) {
                    String name = value.substring(1);
                    EClass eClass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(name);
                    value = Bpmn2ModelerFactory.create(be.eResource(), eClass, new Bpmn2ModelerFactory.KeyValue[0]);
                }
                ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((EObject)be);
                String featureName = entry.getKey().substring(1);
                EStructuralFeature feature = null;
                for (ModelExtensionDescriptor med : rt.getModelExtensionDescriptors()) {
                    feature = med.getEStructuralFeature(className, featureName);
                    if (feature == null) continue;
                    adapter.getFeatureDescriptor(feature).setValue(value);
                    break;
                }
                if (feature != null) continue;
                EClass eClass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(className);
                feature = eClass.getEStructuralFeature(featureName);
                if (feature != null) {
                    adapter.getFeatureDescriptor(feature).setValue(value);
                    continue;
                }
                Activator.logError(new IllegalArgumentException("Error in Tool " + this.getToolName() + ": the model object \"" + className + "\" does not have a \"" + featureName + "\" attribute."));
            }
        }
    }

    public boolean isAvailable(IContext context) {
        if (this.feature != null && !this.feature.isAvailable(context)) {
            return false;
        }
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (ft.isAvailable(context)) continue;
            return false;
        }
        return true;
    }

    public CompoundCreateFeaturePart<CONTEXT> addChild(IFeature feature) {
        CompoundCreateFeaturePart<CONTEXT> node = new CompoundCreateFeaturePart<CONTEXT>(this, feature);
        this.children.add(node);
        return node;
    }

    public EClass getBusinessObjectClass() {
        EClass eClass = null;
        if (this.feature instanceof AbstractBpmn2CreateFeature) {
            eClass = ((AbstractBpmn2CreateFeature)this.feature).getBusinessObjectClass();
        } else if (this.feature instanceof AbstractBpmn2CreateConnectionFeature) {
            eClass = ((AbstractBpmn2CreateConnectionFeature)this.feature).getBusinessObjectClass();
        }
        if (eClass == null) {
            for (CompoundCreateFeaturePart<CONTEXT> child : this.children) {
                EClass ec = child.getBusinessObjectClass();
                if (ec == null) continue;
                eClass = ec;
                break;
            }
        }
        return eClass;
    }

    public String getCreateName() {
        String createName = null;
        if (this.feature != null) {
            createName = this.feature.getName();
        }
        for (CompoundCreateFeaturePart<CONTEXT> child : this.children) {
            String cn = child.getCreateName();
            if (cn == null) continue;
            createName = cn;
        }
        return createName;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public List<CompoundCreateFeaturePart<CONTEXT>> getChildren() {
        return this.children;
    }

    public void setProperties(Hashtable<String, String> properties) {
        this.getProperties().putAll(properties);
    }

    public Hashtable<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public ICompoundCreateFeaturePart getParent() {
        return this.parent;
    }

    @Override
    public String getToolName() {
        return this.parent.getToolName();
    }

    @Override
    public IContext getToolContext() {
        return this.parent.getToolContext();
    }

    @Override
    public List<PictogramElement> getPictogramElements() {
        return this.parent.getPictogramElements();
    }

    @Override
    public void addPictogramElement(PictogramElement pe) {
        this.parent.addPictogramElement(pe);
    }
}

