/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal.handler;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstab;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabCell;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabCellInstance;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabEventHandler;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabInstance;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

public final class CrosstabScriptHandler {
    public static final String ON_PREPARE_CROSSTAB = "onPrepareCrosstab";
    public static final String ON_PREPARE_CELL = "onPrepareCell";
    public static final String ON_CREATE_CROSSTAB = "onCreateCrosstab";
    public static final String ON_CREATE_CELL = "onCreateCell";
    public static final String ON_RENDER_CROSSTAB = "onRenderCrosstab";
    public static final String ON_RENDER_CELL = "onRenderCell";
    private static final Logger logger = Logger.getLogger(CrosstabScriptHandler.class.getName());
    private static final Map<String, Method> JAVA_FUNTION_MAP = new HashMap<String, Method>();
    private Object[] argCache = new Object[2];
    private Scriptable scope;
    private ICrosstabEventHandler javahandler;
    private List<String> javaScriptFunctionNamesCache;

    static {
        Method[] ms = ICrosstabEventHandler.class.getMethods();
        int i = 0;
        while (i < ms.length) {
            JAVA_FUNTION_MAP.put(ms[i].getName(), ms[i]);
            ++i;
        }
    }

    public void init(Scriptable scPrototype) throws CrosstabException {
        Context cx = Context.enter();
        try {
            try {
                if (scPrototype == null) {
                    this.scope = new ImporterTopLevel(cx);
                } else {
                    this.scope = cx.newObject(scPrototype);
                    this.scope.setPrototype(scPrototype);
                }
            }
            catch (RhinoException jsx) {
                throw this.convertException((Exception)((Object)jsx));
            }
        }
        finally {
            Context.exit();
        }
    }

    private Function getJavascriptFunction(String sFunctionName) {
        if (this.javaScriptFunctionNamesCache == null || this.javaScriptFunctionNamesCache.indexOf(sFunctionName) < 0) {
            return null;
        }
        Context.enter();
        try {
            Object oFunction = this.scope.get(sFunctionName, this.scope);
            if (oFunction != Scriptable.NOT_FOUND && oFunction instanceof Function) {
                Function function = (Function)oFunction;
                return function;
            }
            return null;
        }
        finally {
            Context.exit();
        }
    }

    private Object callJavaScriptFunction(Function f, Object[] oaArgs) throws CrosstabException {
        Context cx = Context.enter();
        Object oReturnValue = null;
        try {
            try {
                oReturnValue = f.call(cx, this.scope, this.scope, oaArgs);
            }
            catch (RhinoException ex) {
                throw this.convertException((Exception)((Object)ex));
            }
        }
        finally {
            Context.exit();
        }
        return oReturnValue;
    }

    private Object callJavaFunction(String name, Object[] oaArgs) {
        if (this.javahandler == null) {
            return null;
        }
        if (ON_PREPARE_CROSSTAB.equals(name)) {
            this.javahandler.onPrepareCrosstab((ICrosstab)oaArgs[0], (IReportContext)oaArgs[1]);
        } else if (ON_PREPARE_CELL.equals(name)) {
            this.javahandler.onPrepareCell((ICrosstabCell)oaArgs[0], (IReportContext)oaArgs[1]);
        } else if (ON_CREATE_CROSSTAB.equals(name)) {
            this.javahandler.onCreateCrosstab((ICrosstabInstance)oaArgs[0], (IReportContext)oaArgs[1]);
        } else if (ON_CREATE_CELL.equals(name)) {
            this.javahandler.onCreateCell((ICrosstabCellInstance)oaArgs[0], (IReportContext)oaArgs[1]);
        } else if (ON_RENDER_CROSSTAB.equals(name)) {
            this.javahandler.onRenderCrosstab((ICrosstabInstance)oaArgs[0], (IReportContext)oaArgs[1]);
        } else if (ON_RENDER_CELL.equals(name)) {
            this.javahandler.onRenderCell((ICrosstabCellInstance)oaArgs[0], (IReportContext)oaArgs[1]);
        } else {
            Method mtd = JAVA_FUNTION_MAP.get(name);
            try {
                return mtd.invoke((Object)this.javahandler, oaArgs);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage());
            }
        }
        return null;
    }

    public Object callFunction(String sFunction, Object oArg1, Object oArg2) throws CrosstabException {
        Object rt = null;
        if (this.javahandler != null && JAVA_FUNTION_MAP.containsKey(sFunction)) {
            this.argCache[0] = oArg1;
            this.argCache[1] = oArg2;
            try {
                rt = this.callJavaFunction(sFunction, this.argCache);
            }
            finally {
                this.argCache[0] = null;
                this.argCache[1] = null;
            }
        }
        Function f = this.getJavascriptFunction(sFunction);
        if (f != null) {
            this.argCache[0] = oArg1;
            this.argCache[1] = oArg2;
            try {
                rt = this.callJavaScriptFunction(f, this.argCache);
            }
            finally {
                this.argCache[0] = null;
                this.argCache[1] = null;
            }
        }
        return rt;
    }

    private Class<?> loadJavaHandlerClass(String className, ClassLoader contextLoader) throws ClassNotFoundException {
        Class<?> handlerClass;
        block7: {
            handlerClass = null;
            try {
                handlerClass = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                ClassLoader parentLoader;
                if (contextLoader != null) {
                    try {
                        handlerClass = contextLoader.loadClass(className);
                        if (handlerClass != null) {
                            return handlerClass;
                        }
                    }
                    catch (Throwable throwable) {}
                }
                if ((handlerClass = this.getClassUsingCustomClassPath(className, "webapplication.projectclasspath", parentLoader = CrosstabScriptHandler.class.getClassLoader())) == null && (handlerClass = this.getClassUsingCustomClassPath(className, "user.projectclasspath", parentLoader)) == null) {
                    handlerClass = this.getClassUsingCustomClassPath(className, "workspace.projectclasspath", parentLoader);
                }
                if (handlerClass != null) break block7;
                throw ex;
            }
        }
        return handlerClass;
    }

    private Class<?> getClassUsingCustomClassPath(String className, String classPathKey, ClassLoader parentLoader) {
        String classPath = System.getProperty(classPathKey);
        if (classPath == null || classPath.length() == 0 || className == null) {
            return null;
        }
        String[] classPathArray = classPath.split(EngineConstants.PROPERTYSEPARATOR, -1);
        URL[] urls = null;
        if (classPathArray.length != 0) {
            ArrayList<URL> l = new ArrayList<URL>();
            int i = 0;
            while (i < classPathArray.length) {
                String cpValue = classPathArray[i];
                File file = new File(cpValue);
                try {
                    l.add(file.toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            urls = l.toArray(new URL[l.size()]);
        }
        if (urls != null) {
            URLClassLoader cl = new URLClassLoader(urls, parentLoader);
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    public void register(String sScriptName, String sScriptContent, ClassLoader contextLoader) throws CrosstabException {
        block14: {
            try {
                logger.log(Level.INFO, Messages.getString("CrosstabScriptHandler.info.try.load.crosstab.java.handler"));
                Class<?> handlerClass = this.loadJavaHandlerClass(sScriptContent, contextLoader);
                if (ICrosstabEventHandler.class.isAssignableFrom(handlerClass)) {
                    try {
                        this.javahandler = (ICrosstabEventHandler)handlerClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new CrosstabException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new CrosstabException(e);
                    }
                    logger.log(Level.INFO, Messages.getString("CrosstabScriptHandler.info.crosstab.java.handler.loaded", handlerClass));
                    break block14;
                }
                logger.log(Level.WARNING, Messages.getString("CrosstabScriptHandler.info.invalid.crosstab.java.handler", handlerClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.javahandler = null;
                logger.log(Level.INFO, Messages.getString("CrosstabScriptHandler.info.try.register.crosstab.javascript.content"));
                Context cx = Context.enter();
                try {
                    try {
                        cx.evaluateString(this.scope, sScriptContent, sScriptName == null ? "<cmd>" : sScriptName, 1, null);
                        logger.log(Level.INFO, Messages.getString("CrosstabScriptHandler.info.crosstab.javascript.content.registered"));
                        Object[] objs = this.scope.getIds();
                        if (objs != null) {
                            this.javaScriptFunctionNamesCache = new ArrayList<String>();
                            int i = 0;
                            while (i < objs.length) {
                                this.javaScriptFunctionNamesCache.add(String.valueOf(objs[i]));
                                ++i;
                            }
                        } else {
                            this.javaScriptFunctionNamesCache = null;
                        }
                    }
                    catch (RhinoException jsx) {
                        throw this.convertException((Exception)((Object)jsx));
                    }
                }
                finally {
                    Context.exit();
                }
            }
        }
    }

    protected CrosstabException convertException(Exception ex) {
        if (ex instanceof RhinoException) {
            RhinoException e = (RhinoException)((Object)ex);
            String lineSource = e.lineSource();
            String details = e.details();
            String lineNumber = String.valueOf(e.lineNumber());
            if (lineSource == null) {
                lineSource = "";
            }
            return new CrosstabException(Messages.getString("CrosstabScriptHandler.error.javascript", new Object[]{details, lineNumber, lineSource}));
        }
        return new CrosstabException(ex);
    }
}

