/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.ui.IWorkbenchPart;

public class CopyCellContentsContextAction
extends ContextSelectionAction {
    public static final String ID = "org.eclipse.birt.report.designer.ui.command.copyCellContentsContextAction";

    public CopyCellContentsContextAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages.getString((String)"CopyCellContentsContextAction.actionText"));
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Copy action >> Copy " + this.getSelection());
        }
        try {
            CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.copyCellContentsCommand");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public boolean calculateEnabled() {
        return this.canCopy(this.getSelectedObjects());
    }

    public boolean canCopy(List selection) {
        if (selection.size() == 1 && selection.get(0) instanceof TableCellEditPart) {
            TableCellEditPart tcep = (TableCellEditPart)selection.get(0);
            CellHandle cellHandle = (CellHandle)tcep.getModel();
            return cellHandle.getContent().getCount() > 0;
        }
        return false;
    }
}

