/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.natures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;

public class AcceleoToggleNatureAction
extends AbstractHandler {
    private ISelection selection;
    private boolean enabled;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object applicationContext = null;
        if (event != null) {
            applicationContext = event.getApplicationContext();
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (applicationContext instanceof IEvaluationContext) {
            IEvaluationContext context = (IEvaluationContext)applicationContext;
            Object defaultVariable = context.getDefaultVariable();
            if (defaultVariable instanceof List) {
                List variables = (List)defaultVariable;
                for (Object object : variables) {
                    if (object instanceof IProject) {
                        IProject project = (IProject)object;
                        projects.add(project);
                        continue;
                    }
                    if (object instanceof JavaProject) {
                        JavaProject javaProject = (JavaProject)object;
                        projects.add(javaProject.getProject());
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    projects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
                }
            } else if (defaultVariable instanceof TreeSelection && ((TreeSelection)defaultVariable).size() > 0) {
                TreeSelection tSelection = (TreeSelection)defaultVariable;
                List list = tSelection.toList();
                for (Object object : list) {
                    if (object instanceof IProject) {
                        IProject project = (IProject)object;
                        projects.add(project);
                        continue;
                    }
                    if (object instanceof JavaProject) {
                        JavaProject javaProject = (JavaProject)object;
                        projects.add(javaProject.getProject());
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    projects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
                }
            }
        }
        if (!projects.isEmpty()) {
            this.selection = new StructuredSelection(projects);
        }
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.toggleNature(project);
            }
        }
        return null;
    }

    public void setSelection(ISelection s) {
        this.selection = s;
    }

    private void toggleNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.eclipse.acceleo.ide.ui.acceleoNature".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    ArrayList<IFile> files = new ArrayList<IFile>();
                    this.members(files, (IContainer)project);
                    for (IFile file : files) {
                        try {
                            file.deleteMarkers("org.eclipse.acceleo.ide.ui.problem", false, 0);
                            file.deleteMarkers("org.eclipse.acceleo.ide.ui.warning", false, 0);
                            file.deleteMarkers("org.eclipse.acceleo.ide.ui.info", false, 0);
                        }
                        catch (CoreException e) {
                            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
                        }
                    }
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 2];
            System.arraycopy(natures, 0, newNatures, 2, natures.length);
            newNatures[0] = "org.eclipse.pde.PluginNature";
            newNatures[1] = "org.eclipse.acceleo.ide.ui.acceleoNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
            AcceleoProject acceleoProject = AcceleowizardmodelFactory.eINSTANCE.createAcceleoProject();
            acceleoProject.setName(project.getName());
            acceleoProject.setJre("J2SE-1.5");
            AcceleoUIGenerator.getDefault().generateDotProject(acceleoProject, (IContainer)project);
            IFile buildProperties = project.getFile("build.properties");
            if (!buildProperties.exists()) {
                AcceleoUIGenerator.getDefault().generateBuildProperties(acceleoProject, (IContainer)project);
            }
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
    }

    private void members(List<IFile> files, IContainer container) throws CoreException {
        IResource[] children;
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && "mtl".equals(((IFile)resource).getFileExtension())) {
                    files.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.members(files, (IContainer)resource);
                }
                ++i;
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext context = (IEvaluationContext)evaluationContext;
            Object defaultVariable = context.getDefaultVariable();
            if (defaultVariable instanceof List && ((List)defaultVariable).size() > 0) {
                List variables = (List)defaultVariable;
                for (Object object : variables) {
                    if (object instanceof IProject) {
                        this.enabled = true;
                        continue;
                    }
                    if (object instanceof JavaProject) {
                        this.enabled = true;
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    this.enabled = true;
                }
            } else if (defaultVariable instanceof TreeSelection && ((TreeSelection)defaultVariable).size() > 0) {
                TreeSelection tSelection = (TreeSelection)defaultVariable;
                List list = tSelection.toList();
                for (Object object : list) {
                    if (object instanceof IProject) {
                        this.enabled = true;
                        continue;
                    }
                    if (object instanceof IJavaProject) {
                        this.enabled = true;
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    this.enabled = true;
                }
            }
        } else {
            this.enabled = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

