/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.ecore.CollectionLiteralExp;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AcceleoCreateComparisonResolution
implements IMarkerResolution2 {
    public String getDescription() {
        return AcceleoUIMessages.getString("AcceleoCreateComparisonResolution.Description");
    }

    public Image getImage() {
        return AcceleoUIActivator.getDefault().getImage("icons/quickfix/QuickFixResolveWarning.gif");
    }

    public String getLabel() {
        return AcceleoUIMessages.getString("AcceleoCreateComparisonResolution.Label");
    }

    public void run(IMarker marker) {
        int newOffset;
        AcceleoEditor editor;
        IDocument document;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof AcceleoEditor && (document = (editor = (AcceleoEditor)window.getActivePage().getActiveEditor()).getDocumentProvider().getDocument((Object)editor.getEditorInput())) != null && editor.getContent() != null && (newOffset = this.createWarningResolution(document, editor.getContent(), marker)) > -1) {
            editor.selectAndReveal(newOffset, 0);
        }
    }

    private int createWarningResolution(IDocument document, AcceleoSourceContent content, IMarker marker) {
        try {
            String message = marker.getAttribute("message", "");
            int posBegin = marker.getAttribute("charStart", -1);
            int posEnd = marker.getAttribute("charEnd", posBegin);
            if (message != null && posBegin > -1 && posEnd > -1) {
                ASTNode astNode = content.getASTNode(posBegin, posEnd);
                int equals = 60;
                if (astNode instanceof OperationCallExp && 60 == ((OperationCallExp)astNode).getOperationCode()) {
                    OperationCallExp operationCallExp = (OperationCallExp)astNode;
                    OCLExpression source = operationCallExp.getSource();
                    EList arguments = operationCallExp.getArgument();
                    if (source instanceof CollectionLiteralExp && arguments.size() == 1) {
                        OCLExpression oclExpression = (OCLExpression)arguments.get(0);
                        String collection = document.get().substring(source.getStartPosition(), source.getEndPosition());
                        String argument = document.get().substring(oclExpression.getStartPosition(), oclExpression.getEndPosition());
                        String replacement = String.valueOf(collection) + "->includes(" + argument + ")";
                        document.replace(source.getStartPosition(), oclExpression.getEndPosition() - source.getStartPosition(), replacement);
                        return oclExpression.getEndPosition();
                    }
                }
            }
        }
        catch (BadLocationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
        return -1;
    }

    protected int newOffset(IDocument document, AcceleoSourceContent content, int offset) {
        return document.getLength();
    }
}

