/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLDouble
extends NumberDataType {
    static final int DOUBLE_LENGTH = 32;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDouble.class);
    private double value;
    private boolean isnull;

    @Override
    public int getInt() throws StandardException {
        if (this.value > 2.147483648E9 || this.value < -2.147483649E9) {
            throw StandardException.newException("22003", "INTEGER");
        }
        return (int)this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.value > 128.0 || this.value < -129.0) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() throws StandardException {
        if (this.value > 32768.0 || this.value < -32769.0) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    @Override
    public long getLong() throws StandardException {
        if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
            throw StandardException.newException("22003", "BIGINT");
        }
        return (long)this.value;
    }

    @Override
    public float getFloat() throws StandardException {
        if (Float.isInfinite((float)this.value)) {
            throw StandardException.newException("22003", "REAL");
        }
        return (float)this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int typeToBigDecimal() {
        return 1;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0.0;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Double.toString(this.value);
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    @Override
    void setObject(Object object) throws StandardException {
        this.setValue((Double)object);
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getDouble());
    }

    @Override
    public int getLength() {
        return 32;
    }

    @Override
    public String getTypeName() {
        return "DOUBLE";
    }

    @Override
    public int getTypeFormatId() {
        return 79;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.value);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readDouble();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0.0;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        double d;
        double d2 = this.getDouble();
        if (d2 == (d = dataValueDescriptor.getDouble())) {
            return 0;
        }
        if (d2 > d) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        try {
            return new SQLDouble(this.value, this.isnull);
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLDouble();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws StandardException, SQLException {
        double d = resultSet.getDouble(n);
        this.isnull = bl && resultSet.wasNull();
        this.value = this.isnull ? 0.0 : NumberDataType.normalizeDOUBLE(d);
    }

    @Override
    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, 8);
            return;
        }
        preparedStatement.setDouble(n, this.value);
    }

    @Override
    public final void setInto(ResultSet resultSet, int n) throws SQLException, StandardException {
        resultSet.updateDouble(n, this.value);
    }

    public SQLDouble() {
        this.isnull = true;
    }

    public SQLDouble(double d) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(d);
    }

    public SQLDouble(Double d) throws StandardException {
        this.isnull = d == null;
        if (!this.isnull) {
            this.value = NumberDataType.normalizeDOUBLE(d);
        }
    }

    private SQLDouble(double d, boolean bl) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(d);
        this.isnull = bl;
    }

    @Override
    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0.0;
            this.isnull = true;
        } else {
            double d = 0.0;
            try {
                d = Double.parseDouble(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
            this.value = NumberDataType.normalizeDOUBLE(d);
            this.isnull = false;
        }
    }

    @Override
    public void setValue(double d) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(d);
        this.isnull = false;
    }

    @Override
    public void setValue(float f) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(f);
        this.isnull = false;
    }

    @Override
    public void setValue(long l) {
        this.value = l;
        this.isnull = false;
    }

    @Override
    public void setValue(int n) {
        this.value = n;
        this.isnull = false;
    }

    @Override
    public void setValue(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        this.setValue(number.doubleValue());
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        double d = bigDecimal.doubleValue();
        if (d == 0.0) {
            boolean bl;
            boolean bl2 = bl = bigDecimal.compareTo(BigDecimal.ZERO) == 0;
            if (!bl) {
                throw StandardException.newException("22003", "REAL");
            }
        }
        this.setValue(d);
    }

    @Override
    public void setValue(boolean bl) {
        this.value = bl ? 1.0 : 0.0;
        this.isnull = false;
    }

    @Override
    public int typePrecedence() {
        return 90;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getDouble() == dataValueDescriptor2.getDouble());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getDouble() != dataValueDescriptor2.getDouble());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getDouble() < dataValueDescriptor2.getDouble());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getDouble() > dataValueDescriptor2.getDouble());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getDouble() <= dataValueDescriptor2.getDouble());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getDouble() >= dataValueDescriptor2.getDouble());
    }

    @Override
    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDouble();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d = numberDataValue.getDouble() + numberDataValue2.getDouble();
        numberDataValue3.setValue(d);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDouble();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d = numberDataValue.getDouble() - numberDataValue2.getDouble();
        numberDataValue3.setValue(d);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        double d;
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDouble();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d2 = numberDataValue.getDouble();
        double d3 = d2 * (d = numberDataValue2.getDouble());
        if (d3 == 0.0 && d2 != 0.0 && d != 0.0) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        numberDataValue3.setValue(d3);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDouble();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d = numberDataValue2.getDouble();
        if (d == 0.0) {
            throw StandardException.newException("22012", new Object[0]);
        }
        double d2 = numberDataValue.getDouble();
        double d3 = d2 / d;
        if (Double.isNaN(d3)) {
            throw StandardException.newException("22012", new Object[0]);
        }
        if (d3 == 0.0 && d2 != 0.0) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        numberDataValue3.setValue(d3);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLDouble();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        double d = -this.getDouble();
        numberDataValue.setValue(d);
        return numberDataValue;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0.0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Double.toString(this.value);
    }

    public int hashCode() {
        long l = (long)this.value;
        double d = l;
        if (d != this.value) {
            l = Double.doubleToLongBits(this.value);
        }
        return (int)(l ^ l >> 32);
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

