/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.LengthManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FontSizeManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    public StringMap getIdentifiers() {
        return values;
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public String getPropertyName() {
        return "font-size";
    }

    @Override
    public int getPropertyType() {
        return 39;
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.MEDIUM_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase().intern();
                Object object = values.get(string);
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(string);
                }
                return (Value)object;
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        if (s != 21) {
            throw this.createInvalidStringTypeDOMException(s);
        }
        Object object = values.get(string.toLowerCase().intern());
        if (object == null) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return (Value)object;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        float f = 1.0f;
        boolean bl = false;
        switch (value.getPrimitiveType()) {
            case 1: 
            case 5: {
                return value;
            }
            case 7: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f2 = value.getFloatValue();
                return new FloatValue(1, f2 / cSSContext.getPixelUnitToMillimeter());
            }
            case 6: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f3 = value.getFloatValue();
                return new FloatValue(1, f3 * 10.0f / cSSContext.getPixelUnitToMillimeter());
            }
            case 8: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f4 = value.getFloatValue();
                return new FloatValue(1, f4 * 25.4f / cSSContext.getPixelUnitToMillimeter());
            }
            case 9: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f5 = value.getFloatValue();
                return new FloatValue(1, f5 * 25.4f / (72.0f * cSSContext.getPixelUnitToMillimeter()));
            }
            case 10: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f6 = value.getFloatValue();
                return new FloatValue(1, f6 * 25.4f / (6.0f * cSSContext.getPixelUnitToMillimeter()));
            }
            case 3: {
                bl = true;
                f = value.getFloatValue();
                break;
            }
            case 4: {
                bl = true;
                f = value.getFloatValue() * 0.5f;
                break;
            }
            case 2: {
                bl = true;
                f = value.getFloatValue() * 0.01f;
                break;
            }
        }
        if (value == ValueConstants.LARGER_VALUE) {
            bl = true;
            f = 1.2f;
        } else if (value == ValueConstants.SMALLER_VALUE) {
            bl = true;
            f = 0.8333333f;
        }
        if (bl) {
            float f7;
            styleMap.putParentRelative(n, true);
            CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (cSSStylableElement2 == null) {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                f7 = cSSContext.getMediumFontSize();
            } else {
                f7 = cSSEngine.getComputedStyle(cSSStylableElement2, null, n).getFloatValue();
            }
            return new FloatValue(1, f7 * f);
        }
        CSSContext cSSContext = cSSEngine.getCSSContext();
        float f8 = cSSContext.getMediumFontSize();
        String string2 = value.getStringValue();
        block11 : switch (string2.charAt(0)) {
            case 'm': {
                break;
            }
            case 's': {
                f8 = (float)((double)f8 / 1.2);
                break;
            }
            case 'l': {
                f8 = (float)((double)f8 * 1.2);
                break;
            }
            default: {
                switch (string2.charAt(1)) {
                    case 'x': {
                        switch (string2.charAt(3)) {
                            case 's': {
                                f8 = (float)((double)f8 / 1.2 / 1.2 / 1.2);
                                break block11;
                            }
                        }
                        f8 = (float)((double)f8 * 1.2 * 1.2 * 1.2);
                        break block11;
                    }
                }
                switch (string2.charAt(2)) {
                    case 's': {
                        f8 = (float)((double)f8 / 1.2 / 1.2);
                        break block11;
                    }
                }
                f8 = (float)((double)f8 * 1.2 * 1.2);
            }
        }
        return new FloatValue(1, f8);
    }

    @Override
    protected int getOrientation() {
        return 1;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("large", ValueConstants.LARGE_VALUE);
        values.put("larger", ValueConstants.LARGER_VALUE);
        values.put("medium", ValueConstants.MEDIUM_VALUE);
        values.put("small", ValueConstants.SMALL_VALUE);
        values.put("smaller", ValueConstants.SMALLER_VALUE);
        values.put("x-large", ValueConstants.X_LARGE_VALUE);
        values.put("x-small", ValueConstants.X_SMALL_VALUE);
        values.put("xx-large", ValueConstants.XX_LARGE_VALUE);
        values.put("xx-small", ValueConstants.XX_SMALL_VALUE);
    }
}

