/*
 * Decompiled with CFR 0.152.
 */
package com.naef.jnlua;

import com.naef.jnlua.Converter;
import com.naef.jnlua.DefaultConverter;
import com.naef.jnlua.DefaultJavaReflector;
import com.naef.jnlua.JavaFunction;
import com.naef.jnlua.JavaModule;
import com.naef.jnlua.JavaReflector;
import com.naef.jnlua.LuaMemoryAllocationException;
import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaType;
import com.naef.jnlua.LuaValueProxy;
import com.naef.jnlua.NamedJavaFunction;
import com.naef.jnlua.NativeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;

public class LuaState {
    public static final int MULTRET = -1;
    public static final int REGISTRYINDEX;
    public static final int OK = 0;
    public static final int YIELD = 1;
    public static final int RIDX_MAINTHREAD = 1;
    public static final int RIDX_GLOBALS = 2;
    public static final String VERSION = "1.0";
    public static final String LUA_VERSION;
    private static final int APIVERSION = 3;
    private boolean ownState;
    private long luaState;
    private long luaThread;
    private boolean yield;
    private Object finalizeGuardian;
    private ClassLoader classLoader;
    private JavaReflector javaReflector;
    private Converter converter;
    private Set<LuaValueProxyRef> proxySet = new HashSet<LuaValueProxyRef>();
    private ReferenceQueue<LuaValueProxyImpl> proxyQueue = new ReferenceQueue();

    static {
        NativeSupport.getInstance().getLoader().load();
        REGISTRYINDEX = LuaState.lua_registryindex();
        LUA_VERSION = LuaState.lua_version();
    }

    public LuaState() {
        this(0L);
    }

    private LuaState(long luaState) {
        this.ownState = luaState == 0L;
        this.lua_newstate(3, luaState);
        this.check();
        this.finalizeGuardian = new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finalize() {
                LuaState luaState = LuaState.this;
                synchronized (luaState) {
                    LuaState.this.closeInternal();
                }
            }
        };
        int i = 0;
        while (i < JavaReflector.Metamethod.values().length) {
            final JavaReflector.Metamethod metamethod = JavaReflector.Metamethod.values()[i];
            this.lua_pushjavafunction(new JavaFunction(){

                @Override
                public int invoke(LuaState luaState) {
                    JavaFunction javaFunction = LuaState.this.getMetamethod(luaState.toJavaObjectRaw(1), metamethod);
                    if (javaFunction != null) {
                        return javaFunction.invoke(LuaState.this);
                    }
                    throw new UnsupportedOperationException(metamethod.getMetamethodName());
                }
            });
            this.lua_setfield(-2, metamethod.getMetamethodName());
            ++i;
        }
        this.lua_pop(1);
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.javaReflector = DefaultJavaReflector.getInstance();
        this.converter = DefaultConverter.getInstance();
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.classLoader = classLoader;
    }

    public synchronized JavaReflector getJavaReflector() {
        return this.javaReflector;
    }

    public synchronized void setJavaReflector(JavaReflector javaReflector) {
        if (javaReflector == null) {
            throw new NullPointerException();
        }
        this.javaReflector = javaReflector;
    }

    public synchronized JavaFunction getMetamethod(Object obj, JavaReflector.Metamethod metamethod) {
        JavaFunction javaFunction;
        if (obj != null && obj instanceof JavaReflector && (javaFunction = ((JavaReflector)obj).getMetamethod(metamethod)) != null) {
            return javaFunction;
        }
        return this.javaReflector.getMetamethod(metamethod);
    }

    public synchronized Converter getConverter() {
        return this.converter;
    }

    public synchronized void setConverter(Converter converter) {
        if (converter == null) {
            throw new NullPointerException();
        }
        this.converter = converter;
    }

    public final synchronized boolean isOpen() {
        return this.isOpenInternal();
    }

    public synchronized void close() {
        this.closeInternal();
    }

    public synchronized int gc(GcAction what, int data) {
        this.check();
        return this.lua_gc(what.ordinal(), data);
    }

    public synchronized void openLib(Library library) {
        this.check();
        library.open(this);
    }

    public synchronized void openLibs() {
        this.check();
        Library[] libraryArray = Library.values();
        int n = libraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Library library = libraryArray[n2];
            library.open(this);
            this.pop(1);
            ++n2;
        }
    }

    public synchronized void register(NamedJavaFunction namedJavaFunction) {
        this.check();
        String name = namedJavaFunction.getName();
        if (name == null) {
            throw new IllegalArgumentException("anonymous function");
        }
        this.pushJavaFunction(namedJavaFunction);
        this.setGlobal(name);
    }

    public synchronized void register(String moduleName, NamedJavaFunction[] namedJavaFunctions, boolean global) {
        this.check();
        this.newTable(0, namedJavaFunctions.length);
        int i = 0;
        while (i < namedJavaFunctions.length) {
            String name = namedJavaFunctions[i].getName();
            if (name == null) {
                throw new IllegalArgumentException(String.format("anonymous function at index %d", i));
            }
            this.pushJavaFunction(namedJavaFunctions[i]);
            this.setField(-2, name);
            ++i;
        }
        this.lua_getsubtable(REGISTRYINDEX, "_LOADED");
        this.pushValue(-2);
        this.setField(-2, moduleName);
        this.pop(1);
        if (global) {
            this.rawGet(REGISTRYINDEX, 2);
            this.pushValue(-2);
            this.setField(-2, moduleName);
            this.pop(1);
        }
    }

    public synchronized void load(InputStream inputStream, String chunkName, String mode) throws IOException {
        this.check();
        this.lua_load(inputStream, chunkName, mode);
    }

    public synchronized void load(String chunk, String chunkName) {
        this.check();
        try {
            this.load(new ByteArrayInputStream(chunk.getBytes("UTF-8")), chunkName, "t");
        }
        catch (IOException e) {
            throw new LuaMemoryAllocationException(e.getMessage(), e);
        }
    }

    public synchronized void dump(OutputStream outputStream) throws IOException {
        this.check();
        this.lua_dump(outputStream);
    }

    public synchronized void call(int argCount, int returnCount) {
        this.check();
        this.lua_pcall(argCount, returnCount);
    }

    public synchronized void getGlobal(String name) {
        this.check();
        this.lua_getglobal(name);
    }

    public synchronized void setGlobal(String name) throws LuaMemoryAllocationException, LuaRuntimeException {
        this.check();
        this.lua_setglobal(name);
    }

    public synchronized void pushBoolean(boolean b) {
        this.check();
        this.lua_pushboolean(b ? 1 : 0);
    }

    public synchronized void pushByteArray(byte[] b) {
        this.check();
        this.lua_pushbytearray(b);
    }

    public synchronized void pushInteger(int n) {
        this.check();
        this.lua_pushinteger(n);
    }

    public synchronized void pushJavaFunction(JavaFunction javaFunction) {
        this.check();
        this.lua_pushjavafunction(javaFunction);
    }

    public synchronized void pushJavaObject(Object object) {
        this.check();
        this.getConverter().convertJavaObject(this, object);
    }

    public synchronized void pushJavaObjectRaw(Object object) {
        this.check();
        this.lua_pushjavaobject(object);
    }

    public synchronized void pushNil() {
        this.check();
        this.lua_pushnil();
    }

    public synchronized void pushNumber(double n) {
        this.check();
        this.lua_pushnumber(n);
    }

    public synchronized void pushString(String s) {
        this.check();
        this.lua_pushstring(s);
    }

    public synchronized boolean isBoolean(int index) {
        this.check();
        return this.lua_isboolean(index) != 0;
    }

    public synchronized boolean isCFunction(int index) {
        this.check();
        return this.lua_iscfunction(index) != 0;
    }

    public synchronized boolean isFunction(int index) {
        this.check();
        return this.lua_isfunction(index) != 0;
    }

    public synchronized boolean isJavaFunction(int index) {
        this.check();
        return this.lua_isjavafunction(index) != 0;
    }

    public synchronized boolean isJavaObject(int index, Class<?> type) {
        this.check();
        return this.converter.getTypeDistance(this, index, type) != Integer.MAX_VALUE;
    }

    public synchronized boolean isJavaObjectRaw(int index) {
        this.check();
        return this.lua_isjavaobject(index) != 0;
    }

    public synchronized boolean isNil(int index) {
        this.check();
        return this.lua_isnil(index) != 0;
    }

    public synchronized boolean isNone(int index) {
        this.check();
        return this.lua_isnone(index) != 0;
    }

    public synchronized boolean isNoneOrNil(int index) {
        this.check();
        return this.lua_isnoneornil(index) != 0;
    }

    public synchronized boolean isNumber(int index) {
        this.check();
        return this.lua_isnumber(index) != 0;
    }

    public synchronized boolean isString(int index) {
        this.check();
        return this.lua_isstring(index) != 0;
    }

    public synchronized boolean isTable(int index) {
        this.check();
        return this.lua_istable(index) != 0;
    }

    public synchronized boolean isThread(int index) {
        this.check();
        return this.lua_isthread(index) != 0;
    }

    public synchronized boolean compare(int index1, int index2, RelOperator operator) {
        this.check();
        return this.lua_compare(index1, index2, operator.ordinal()) != 0;
    }

    public synchronized boolean equal(int index1, int index2) {
        return this.compare(index1, index2, RelOperator.EQ);
    }

    public synchronized int length(int index) {
        return this.rawLen(index);
    }

    public synchronized boolean lessThan(int index1, int index2) throws LuaMemoryAllocationException, LuaRuntimeException {
        return this.compare(index1, index2, RelOperator.LT);
    }

    public synchronized boolean rawEqual(int index1, int index2) {
        this.check();
        return this.lua_rawequal(index1, index2) != 0;
    }

    public synchronized int rawLen(int index) {
        this.check();
        return this.lua_rawlen(index);
    }

    public synchronized boolean toBoolean(int index) {
        this.check();
        return this.lua_toboolean(index) != 0;
    }

    public synchronized byte[] toByteArray(int index) {
        this.check();
        return this.lua_tobytearray(index);
    }

    public synchronized int toInteger(int index) {
        this.check();
        return this.lua_tointeger(index);
    }

    public synchronized Integer toIntegerX(int index) {
        this.check();
        return this.lua_tointegerx(index);
    }

    public synchronized JavaFunction toJavaFunction(int index) {
        this.check();
        return this.lua_tojavafunction(index);
    }

    public synchronized <T> T toJavaObject(int index, Class<T> type) {
        this.check();
        return this.converter.convertLuaValue(this, index, type);
    }

    public synchronized Object toJavaObjectRaw(int index) {
        this.check();
        return this.lua_tojavaobject(index);
    }

    public synchronized double toNumber(int index) {
        this.check();
        return this.lua_tonumber(index);
    }

    public synchronized Double toNumberX(int index) {
        this.check();
        return this.lua_tonumberx(index);
    }

    public synchronized long toPointer(int index) {
        this.check();
        return this.lua_topointer(index);
    }

    public synchronized String toString(int index) {
        this.check();
        return this.lua_tostring(index);
    }

    public synchronized LuaType type(int index) {
        this.check();
        int type = this.lua_type(index);
        return type >= 0 ? LuaType.values()[type] : null;
    }

    public synchronized String typeName(int index) {
        this.check();
        LuaType type = this.type(index);
        if (type == null) {
            return "none";
        }
        switch (type) {
            case USERDATA: {
                if (!this.isJavaObjectRaw(index)) break;
                Object object = this.toJavaObjectRaw(index);
                Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
                return clazz.getCanonicalName();
            }
        }
        return type.displayText();
    }

    public synchronized int absIndex(int index) {
        this.check();
        return this.lua_absindex(index);
    }

    public synchronized void arith(ArithOperator operator) {
        this.check();
        this.lua_arith(operator.ordinal());
    }

    public synchronized void concat(int n) {
        this.check();
        this.lua_concat(n);
    }

    public synchronized void copy(int fromIndex, int toIndex) {
        this.check();
        this.lua_copy(fromIndex, toIndex);
    }

    public synchronized int getTop() {
        this.check();
        return this.lua_gettop();
    }

    public synchronized void len(int index) {
        this.check();
        this.lua_len(index);
    }

    public synchronized void insert(int index) {
        this.check();
        this.lua_insert(index);
    }

    public synchronized void pop(int count) {
        this.check();
        this.lua_pop(count);
    }

    public synchronized void pushValue(int index) {
        this.check();
        this.lua_pushvalue(index);
    }

    public synchronized void remove(int index) {
        this.check();
        this.lua_remove(index);
    }

    public synchronized void replace(int index) {
        this.check();
        this.lua_replace(index);
    }

    public synchronized void setTop(int index) {
        this.check();
        this.lua_settop(index);
    }

    public synchronized void getTable(int index) {
        this.check();
        this.lua_gettable(index);
    }

    public synchronized void getField(int index, String key) {
        this.check();
        this.lua_getfield(index, key);
    }

    public synchronized void newTable() {
        this.check();
        this.lua_newtable();
    }

    public synchronized void newTable(int arrayCount, int recordCount) {
        this.check();
        this.lua_createtable(arrayCount, recordCount);
    }

    public synchronized boolean next(int index) {
        this.check();
        return this.lua_next(index) != 0;
    }

    public synchronized void rawGet(int index) {
        this.check();
        this.lua_rawget(index);
    }

    public synchronized void rawGet(int index, int key) {
        this.check();
        this.lua_rawgeti(index, key);
    }

    public synchronized void rawSet(int index) {
        this.check();
        this.lua_rawset(index);
    }

    public synchronized void rawSet(int index, int key) {
        this.check();
        this.lua_rawseti(index, key);
    }

    public synchronized void setTable(int index) {
        this.check();
        this.lua_settable(index);
    }

    public synchronized void setField(int index, String key) {
        this.check();
        this.lua_setfield(index, key);
    }

    public synchronized boolean getMetafield(int index, String key) {
        this.check();
        return this.lua_getmetafield(index, key) != 0;
    }

    public synchronized boolean getMetatable(int index) {
        this.check();
        return this.lua_getmetatable(index) != 0;
    }

    public synchronized void setMetatable(int index) {
        this.check();
        this.lua_setmetatable(index);
    }

    public synchronized void newThread() {
        this.check();
        this.lua_newthread();
    }

    public synchronized int resume(int index, int argCount) {
        this.check();
        return this.lua_resume(index, argCount);
    }

    public synchronized int status(int index) {
        this.check();
        return this.lua_status(index);
    }

    public synchronized int yield(int returnCount) {
        this.check();
        this.yield = true;
        return returnCount;
    }

    public synchronized int ref(int index) {
        this.check();
        return this.lua_ref(index);
    }

    public synchronized void unref(int index, int reference) {
        this.check();
        this.lua_unref(index, reference);
    }

    public synchronized int tableSize(int index) {
        this.check();
        return this.lua_tablesize(index);
    }

    public synchronized void tableMove(int index, int from, int to, int count) {
        this.check();
        this.lua_tablemove(index, from, to, count);
    }

    public synchronized void checkArg(int index, boolean condition, String msg) {
        this.check();
        if (!condition) {
            throw this.getArgException(index, msg);
        }
    }

    public synchronized byte[] checkByteArray(int index) {
        this.check();
        if (!this.isString(index)) {
            throw this.getArgTypeException(index, LuaType.STRING);
        }
        return this.toByteArray(index);
    }

    public synchronized byte[] checkByteArray(int index, byte[] d) {
        this.check();
        if (this.isNoneOrNil(index)) {
            return d;
        }
        return this.checkByteArray(index);
    }

    public synchronized <T extends Enum<T>> T checkEnum(int index, T[] values) {
        this.check();
        return (T)this.checkEnum(index, (Enum[])values, null);
    }

    public synchronized <T extends Enum<T>> T checkEnum(int index, T[] values, T d) {
        this.check();
        String s = d != null ? this.checkString(index, d.name()) : this.checkString(index);
        int i = 0;
        while (i < values.length) {
            if (((Enum)values[i]).name().equals(s)) {
                return values[i];
            }
            ++i;
        }
        throw this.getArgException(index, String.format("invalid option '%s'", s));
    }

    public synchronized int checkInteger(int index) {
        this.check();
        Integer integer = this.toIntegerX(index);
        if (integer == null) {
            throw this.getArgTypeException(index, LuaType.NUMBER);
        }
        return integer;
    }

    public synchronized int checkInteger(int index, int d) {
        this.check();
        if (this.isNoneOrNil(index)) {
            return d;
        }
        return this.checkInteger(index);
    }

    public synchronized <T> T checkJavaObject(int index, Class<T> clazz) {
        this.check();
        if (!this.isJavaObject(index, clazz)) {
            this.checkArg(index, false, String.format("%s expected, got %s", clazz.getCanonicalName(), this.typeName(index)));
        }
        return this.toJavaObject(index, clazz);
    }

    public synchronized <T> T checkJavaObject(int index, Class<T> clazz, T d) {
        this.check();
        if (this.isNoneOrNil(index)) {
            return d;
        }
        return this.checkJavaObject(index, clazz);
    }

    public synchronized double checkNumber(int index) {
        this.check();
        Double number = this.toNumberX(index);
        if (number == null) {
            throw this.getArgTypeException(index, LuaType.NUMBER);
        }
        return number;
    }

    public synchronized double checkNumber(int index, double d) {
        this.check();
        if (this.isNoneOrNil(index)) {
            return d;
        }
        return this.checkNumber(index);
    }

    public synchronized int checkOption(int index, String[] options) {
        this.check();
        return this.checkOption(index, options, null);
    }

    public synchronized int checkOption(int index, String[] options, String d) {
        this.check();
        String s = d != null ? this.checkString(index, d) : this.checkString(index);
        int i = 0;
        while (i < options.length) {
            if (options[i].equals(s)) {
                return i;
            }
            ++i;
        }
        throw this.getArgException(index, String.format("invalid option '%s'", s));
    }

    public synchronized String checkString(int index) {
        this.check();
        if (!this.isString(index)) {
            throw this.getArgTypeException(index, LuaType.STRING);
        }
        return this.toString(index);
    }

    public synchronized String checkString(int index, String d) {
        this.check();
        if (this.isNoneOrNil(index)) {
            return d;
        }
        return this.checkString(index);
    }

    public synchronized void checkType(int index, LuaType type) {
        this.check();
        if (this.type(index) != type) {
            throw this.getArgTypeException(index, type);
        }
    }

    public synchronized LuaValueProxy getProxy(int index) {
        this.check();
        this.pushValue(index);
        return new LuaValueProxyImpl(this.ref(REGISTRYINDEX));
    }

    public synchronized <T> T getProxy(int index, Class<T> interfaze) {
        this.check();
        return (T)this.getProxy(index, new Class[]{interfaze});
    }

    public synchronized LuaValueProxy getProxy(int index, Class<?>[] interfaces) {
        this.check();
        this.pushValue(index);
        if (!this.isTable(index)) {
            throw new IllegalArgumentException(String.format("index %d is not a table", index));
        }
        Class[] allInterfaces = new Class[interfaces.length + 1];
        System.arraycopy(interfaces, 0, allInterfaces, 0, interfaces.length);
        allInterfaces[allInterfaces.length - 1] = LuaValueProxy.class;
        int reference = this.ref(REGISTRYINDEX);
        try {
            Object proxy = Proxy.newProxyInstance(this.classLoader, allInterfaces, (InvocationHandler)new LuaInvocationHandler(reference));
            reference = -1;
            LuaValueProxy luaValueProxy = (LuaValueProxy)proxy;
            return luaValueProxy;
        }
        finally {
            if (reference >= 0) {
                this.unref(REGISTRYINDEX, reference);
            }
        }
    }

    private boolean isOpenInternal() {
        return this.luaState != 0L;
    }

    private void closeInternal() {
        if (this.isOpenInternal()) {
            this.lua_close(this.ownState);
            if (this.isOpenInternal()) {
                throw new IllegalStateException("cannot close");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void check() {
        if (this.isOpenInternal()) ** GOTO lbl6
        throw new IllegalStateException("Lua state is closed");
lbl-1000:
        // 1 sources

        {
            this.proxySet.remove(luaValueProxyRef);
            this.lua_unref(LuaState.REGISTRYINDEX, luaValueProxyRef.getReference());
lbl6:
            // 2 sources

            ** while ((luaValueProxyRef = (LuaValueProxyRef)this.proxyQueue.poll()) != null)
        }
lbl7:
        // 1 sources

    }

    private LuaRuntimeException getArgTypeException(int index, LuaType type) {
        return this.getArgException(index, String.format("%s expected, got %s", type.toString().toLowerCase(), this.type(index).toString().toLowerCase()));
    }

    private LuaRuntimeException getArgException(int index, String extraMsg) {
        this.check();
        String name = null;
        String nameWhat = null;
        LuaDebug luaDebug = this.lua_getstack(0);
        if (luaDebug != null) {
            this.lua_getinfo("n", luaDebug);
            name = luaDebug.getName();
            nameWhat = luaDebug.getNameWhat();
        }
        if ("method".equals(nameWhat)) {
            --index;
        }
        String argument = index > 0 ? String.format("argument #%d", index) : "self argument";
        String msg = name != null ? String.format("bad %s to '%s' (%s)", argument, name, extraMsg) : String.format("bad %s (%s)", argument, extraMsg);
        return new LuaRuntimeException(msg);
    }

    private static native int lua_registryindex();

    private static native String lua_version();

    private native void lua_newstate(int var1, long var2);

    private native void lua_close(boolean var1);

    private native int lua_gc(int var1, int var2);

    private native void lua_openlib(int var1);

    private native void lua_load(InputStream var1, String var2, String var3) throws IOException;

    private native void lua_dump(OutputStream var1) throws IOException;

    private native void lua_pcall(int var1, int var2);

    private native void lua_getglobal(String var1);

    private native void lua_setglobal(String var1);

    private native void lua_pushboolean(int var1);

    private native void lua_pushbytearray(byte[] var1);

    private native void lua_pushinteger(int var1);

    private native void lua_pushjavafunction(JavaFunction var1);

    private native void lua_pushjavaobject(Object var1);

    private native void lua_pushnil();

    private native void lua_pushnumber(double var1);

    private native void lua_pushstring(String var1);

    private native int lua_isboolean(int var1);

    private native int lua_iscfunction(int var1);

    private native int lua_isfunction(int var1);

    private native int lua_isjavafunction(int var1);

    private native int lua_isjavaobject(int var1);

    private native int lua_isnil(int var1);

    private native int lua_isnone(int var1);

    private native int lua_isnoneornil(int var1);

    private native int lua_isnumber(int var1);

    private native int lua_isstring(int var1);

    private native int lua_istable(int var1);

    private native int lua_isthread(int var1);

    private native int lua_compare(int var1, int var2, int var3);

    private native int lua_rawequal(int var1, int var2);

    private native int lua_rawlen(int var1);

    private native int lua_toboolean(int var1);

    private native byte[] lua_tobytearray(int var1);

    private native int lua_tointeger(int var1);

    private native Integer lua_tointegerx(int var1);

    private native JavaFunction lua_tojavafunction(int var1);

    private native Object lua_tojavaobject(int var1);

    private native double lua_tonumber(int var1);

    private native Double lua_tonumberx(int var1);

    private native long lua_topointer(int var1);

    private native String lua_tostring(int var1);

    private native int lua_type(int var1);

    private native int lua_absindex(int var1);

    private native int lua_arith(int var1);

    private native void lua_concat(int var1);

    private native int lua_copy(int var1, int var2);

    private native int lua_gettop();

    private native void lua_len(int var1);

    private native void lua_insert(int var1);

    private native void lua_pop(int var1);

    private native void lua_pushvalue(int var1);

    private native void lua_remove(int var1);

    private native void lua_replace(int var1);

    private native void lua_settop(int var1);

    private native void lua_createtable(int var1, int var2);

    private native int lua_getsubtable(int var1, String var2);

    private native void lua_gettable(int var1);

    private native void lua_getfield(int var1, String var2);

    private native void lua_newtable();

    private native int lua_next(int var1);

    private native void lua_rawget(int var1);

    private native void lua_rawgeti(int var1, int var2);

    private native void lua_rawset(int var1);

    private native void lua_rawseti(int var1, int var2);

    private native void lua_settable(int var1);

    private native void lua_setfield(int var1, String var2);

    private native int lua_getmetatable(int var1);

    private native void lua_setmetatable(int var1);

    private native int lua_getmetafield(int var1, String var2);

    private native void lua_newthread();

    private native int lua_resume(int var1, int var2);

    private native int lua_status(int var1);

    private native int lua_ref(int var1);

    private native void lua_unref(int var1, int var2);

    private native LuaDebug lua_getstack(int var1);

    private native int lua_getinfo(String var1, LuaDebug var2);

    private native int lua_tablesize(int var1);

    private native void lua_tablemove(int var1, int var2, int var3, int var4);

    public static enum ArithOperator {
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        POW,
        UNM;

    }

    public static enum GcAction {
        STOP,
        RESTART,
        COLLECT,
        COUNT,
        COUNTB,
        STEP,
        SETPAUSE,
        SETSTEPMUL,
        SETMAJORINC,
        ISRUNNING,
        GEN,
        INC;

    }

    public static enum Library {
        BASE,
        PACKAGE,
        COROUTINE,
        TABLE,
        IO,
        OS,
        STRING,
        BIT32,
        MATH,
        DEBUG,
        JAVA{

            @Override
            void open(LuaState luaState) {
                JavaModule.getInstance().open(luaState);
            }
        };


        void open(LuaState luaState) {
            luaState.lua_openlib(this.ordinal());
        }
    }

    private static class LuaDebug {
        private long luaDebug;
        private Object finalizeGuardian;

        private LuaDebug(long luaDebug, boolean ownDebug) {
            this.luaDebug = luaDebug;
            if (ownDebug) {
                this.finalizeGuardian = new Object(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void finalize() {
                        LuaDebug luaDebug = LuaDebug.this;
                        synchronized (luaDebug) {
                            LuaDebug.this.lua_debugfree();
                        }
                    }
                };
            }
        }

        public String getName() {
            return this.lua_debugname();
        }

        public String getNameWhat() {
            return this.lua_debugnamewhat();
        }

        private native void lua_debugfree();

        private native String lua_debugname();

        private native String lua_debugnamewhat();
    }

    private class LuaInvocationHandler
    extends LuaValueProxyImpl
    implements InvocationHandler {
        public LuaInvocationHandler(int reference) {
            super(reference);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == LuaValueProxy.class) {
                return method.invoke((Object)this, args);
            }
            LuaState luaState = LuaState.this;
            synchronized (luaState) {
                Object var8_7;
                block10: {
                    this.pushValue();
                    LuaState.this.getField(-1, method.getName());
                    if (!LuaState.this.isFunction(-1)) {
                        LuaState.this.pop(2);
                        throw new UnsupportedOperationException(method.getName());
                    }
                    LuaState.this.insert(-2);
                    int argCount = args != null ? args.length : 0;
                    int i = 0;
                    while (i < argCount) {
                        LuaState.this.pushJavaObject(args[i]);
                        ++i;
                    }
                    int retCount = method.getReturnType() != Void.TYPE ? 1 : 0;
                    LuaState.this.call(argCount + 1, retCount);
                    try {
                        Object v0 = var8_7 = retCount == 1 ? LuaState.this.toJavaObject(-1, method.getReturnType()) : null;
                        if (retCount != 1) break block10;
                        LuaState.this.pop(1);
                    }
                    catch (Throwable throwable) {
                        if (retCount == 1) {
                            LuaState.this.pop(1);
                        }
                        throw throwable;
                    }
                }
                return var8_7;
            }
        }
    }

    private class LuaValueProxyImpl
    implements LuaValueProxy {
        private int reference;

        public LuaValueProxyImpl(int reference) {
            this.reference = reference;
            LuaState.this.proxySet.add(new LuaValueProxyRef(this, reference));
        }

        @Override
        public LuaState getLuaState() {
            return LuaState.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pushValue() {
            LuaState luaState = LuaState.this;
            synchronized (luaState) {
                LuaState.this.rawGet(REGISTRYINDEX, this.reference);
            }
        }
    }

    private static class LuaValueProxyRef
    extends PhantomReference<LuaValueProxyImpl> {
        private int reference;

        public LuaValueProxyRef(LuaValueProxyImpl luaProxyImpl, int reference) {
            super(luaProxyImpl, luaProxyImpl.getLuaState().proxyQueue);
            this.reference = reference;
        }

        public int getReference() {
            return this.reference;
        }
    }

    public static enum RelOperator {
        EQ,
        LT,
        LE;

    }
}

