/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.ser;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwtjsonrpc.client.impl.JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.client.impl.ser.PrimitiveResultDeserializers;
import java.sql.Date;

public final class JavaSqlDate_JsonSerializer
extends JsonSerializer<Date>
implements ResultDeserializer<Date> {
    public static final JavaSqlDate_JsonSerializer INSTANCE = new JavaSqlDate_JsonSerializer();

    @Override
    public Date fromJson(Object o) {
        if (o != null) {
            return JavaSqlDate_JsonSerializer.parseDate((String)o);
        }
        return null;
    }

    @Override
    public void printJson(StringBuilder sb, Date o) {
        sb.append('\"');
        sb.append(JavaSqlDate_JsonSerializer.toString(o.getTime()));
        sb.append('\"');
    }

    private static native String toString(double var0);

    protected static Date parseDate(String s) {
        String[] split = s.split("-");
        if (split.length != 3) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
        if (split[1].startsWith("0")) {
            split[1] = split[1].substring(1);
        }
        if (split[2].startsWith("0")) {
            split[2] = split[2].substring(1);
        }
        try {
            int y = Integer.valueOf(split[0]) - 1900;
            int m = Integer.decode(split[1]) - 1;
            int d = Integer.decode(split[2]);
            return new Date(y, m, d);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
    }

    @Override
    public Date fromResult(JavaScriptObject responseObject) {
        return this.fromJson(PrimitiveResultDeserializers.stringResult(responseObject));
    }
}

