/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInputChange;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Conversions;

@SuppressWarnings("all")
public class QueryRegistryTreeContentProvider implements ITreeContentProvider {
  @FinalFieldsConstructor
  public static class QueryRegistryTreeViewListener implements IQuerySpecificationRegistryChangeListener {
    private final QueryRegistryTreeInput input;
    
    private final TreeViewer viewer;
    
    @Override
    public void entryAdded(final IQuerySpecificationRegistryEntry entry) {
      final QueryRegistryTreeInputChange newEntry = this.input.addEntryToInput(entry);
      final Runnable _function = () -> {
        boolean _isSourceAffected = newEntry.isSourceAffected();
        if (_isSourceAffected) {
          this.viewer.add(this.input, newEntry.getSource());
        }
        boolean _isPckgAffected = newEntry.isPckgAffected();
        if (_isPckgAffected) {
          this.viewer.add(newEntry.getSource(), newEntry.getPckg());
        }
        this.viewer.add(newEntry.getPckg(), newEntry.getEntry());
      };
      this.viewer.getTree().getDisplay().asyncExec(_function);
    }
    
    @Override
    public void entryRemoved(final IQuerySpecificationRegistryEntry entry) {
      final QueryRegistryTreeInputChange oldEntry = this.input.removeEntry(entry);
      if ((oldEntry != null)) {
        final Runnable _function = () -> {
          this.viewer.remove(oldEntry.getEntry());
          boolean _isPckgAffected = oldEntry.isPckgAffected();
          if (_isPckgAffected) {
            this.viewer.remove(oldEntry.getPckg());
          }
          boolean _isSourceAffected = oldEntry.isSourceAffected();
          if (_isSourceAffected) {
            this.viewer.remove(oldEntry.getSource());
          }
        };
        this.viewer.getTree().getDisplay().asyncExec(_function);
      }
    }
    
    public QueryRegistryTreeViewListener(final QueryRegistryTreeInput input, final TreeViewer viewer) {
      super();
      this.input = input;
      this.viewer = viewer;
    }
  }
  
  protected TreeViewer viewer;
  
  protected QueryRegistryTreeInput input;
  
  @Override
  public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
    Preconditions.checkArgument((viewer instanceof TreeViewer));
    this.viewer = ((TreeViewer) viewer);
    if ((oldInput instanceof QueryRegistryTreeInput)) {
      ((QueryRegistryTreeInput)oldInput).setListener(null);
    }
    if ((newInput instanceof QueryRegistryTreeInput)) {
      this.input = ((QueryRegistryTreeInput) newInput);
      QueryRegistryTreeContentProvider.QueryRegistryTreeViewListener _queryRegistryTreeViewListener = new QueryRegistryTreeContentProvider.QueryRegistryTreeViewListener(((QueryRegistryTreeInput)newInput), this.viewer);
      ((QueryRegistryTreeInput)newInput).setListener(_queryRegistryTreeViewListener);
    } else {
      if ((newInput != null)) {
        String _format = String.format("Invalid input type %s for Query Registry.", newInput.getClass().getName());
        throw new IllegalArgumentException(_format);
      }
    }
  }
  
  @Override
  public void dispose() {
  }
  
  @Override
  public Object[] getElements(final Object inputElement) {
    return this.getChildren(inputElement);
  }
  
  @Override
  public Object[] getChildren(final Object parentElement) {
    return this.getChildrenInternal(parentElement);
  }
  
  protected Object[] _getChildrenInternal(final QueryRegistryTreeInput parentElement) {
    return ((Object[])Conversions.unwrapArray(parentElement.getSources().values(), Object.class));
  }
  
  protected Object[] _getChildrenInternal(final QueryRegistryTreeSource parentElement) {
    return ((Object[])Conversions.unwrapArray(parentElement.getPackages().values(), Object.class));
  }
  
  protected Object[] _getChildrenInternal(final QueryRegistryTreePackage parentElement) {
    return ((Object[])Conversions.unwrapArray(parentElement.getEntries().values(), Object.class));
  }
  
  protected Object[] _getChildrenInternal(final QueryRegistryTreeEntry parentElement) {
    return null;
  }
  
  @Override
  public Object getParent(final Object element) {
    return this.getParentInternal(element);
  }
  
  protected Object _getParentInternal(final QueryRegistryTreeInput element) {
    return null;
  }
  
  protected Object _getParentInternal(final QueryRegistryTreeSource element) {
    return element.getParent();
  }
  
  protected Object _getParentInternal(final QueryRegistryTreePackage element) {
    return element.getParent();
  }
  
  protected Object _getParentInternal(final QueryRegistryTreeEntry element) {
    return element.getParent();
  }
  
  @Override
  public boolean hasChildren(final Object element) {
    return this.hasChildrenInternal(element);
  }
  
  protected boolean _hasChildrenInternal(final QueryRegistryTreeInput element) {
    boolean _isEmpty = element.getSources().isEmpty();
    return (!_isEmpty);
  }
  
  protected boolean _hasChildrenInternal(final QueryRegistryTreeSource element) {
    boolean _isEmpty = element.getPackages().isEmpty();
    return (!_isEmpty);
  }
  
  protected boolean _hasChildrenInternal(final QueryRegistryTreePackage element) {
    boolean _isEmpty = element.getEntries().isEmpty();
    return (!_isEmpty);
  }
  
  protected boolean _hasChildrenInternal(final QueryRegistryTreeEntry element) {
    return false;
  }
  
  public Object[] getChildrenInternal(final Object parentElement) {
    if (parentElement instanceof QueryRegistryTreeEntry) {
      return _getChildrenInternal((QueryRegistryTreeEntry)parentElement);
    } else if (parentElement instanceof QueryRegistryTreeInput) {
      return _getChildrenInternal((QueryRegistryTreeInput)parentElement);
    } else if (parentElement instanceof QueryRegistryTreePackage) {
      return _getChildrenInternal((QueryRegistryTreePackage)parentElement);
    } else if (parentElement instanceof QueryRegistryTreeSource) {
      return _getChildrenInternal((QueryRegistryTreeSource)parentElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(parentElement).toString());
    }
  }
  
  public Object getParentInternal(final Object element) {
    if (element instanceof QueryRegistryTreeEntry) {
      return _getParentInternal((QueryRegistryTreeEntry)element);
    } else if (element instanceof QueryRegistryTreeInput) {
      return _getParentInternal((QueryRegistryTreeInput)element);
    } else if (element instanceof QueryRegistryTreePackage) {
      return _getParentInternal((QueryRegistryTreePackage)element);
    } else if (element instanceof QueryRegistryTreeSource) {
      return _getParentInternal((QueryRegistryTreeSource)element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
  
  public boolean hasChildrenInternal(final Object element) {
    if (element instanceof QueryRegistryTreeEntry) {
      return _hasChildrenInternal((QueryRegistryTreeEntry)element);
    } else if (element instanceof QueryRegistryTreeInput) {
      return _hasChildrenInternal((QueryRegistryTreeInput)element);
    } else if (element instanceof QueryRegistryTreePackage) {
      return _hasChildrenInternal((QueryRegistryTreePackage)element);
    } else if (element instanceof QueryRegistryTreeSource) {
      return _hasChildrenInternal((QueryRegistryTreeSource)element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
}
