/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.Collections;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.AbstractIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterUnary;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IMemory;

public class SimpleUnaryTable<Value>
extends AbstractIndexTable
implements ITableWriterUnary.Table<Value> {
    protected IMemory<Value> values = CollectionsFactory.createMultiset();
    private boolean unique;

    public SimpleUnaryTable(IInputKey inputKey, ITableContext tableContext, boolean unique) {
        super(inputKey, tableContext);
        this.unique = unique;
        if (1 != inputKey.getArity()) {
            throw new IllegalArgumentException(inputKey.toString());
        }
    }

    @Override
    public void write(Direction direction, Value value) {
        if (direction == Direction.INSERT) {
            boolean changed = this.values.addOne(value);
            if (this.unique && !changed) {
                String msg = String.format("Error: trying to add duplicate value %s to the unique set %s. This indicates some errors in underlying model representation.", value, this.getInputKey().getPrettyPrintableName());
                this.logError(msg);
            }
        } else {
            boolean changed = this.values.removeOne(value);
            if (this.unique && !changed) {
                String msg = String.format("Error: trying to remove duplicate value %s from the unique set %s. This indicates some errors in underlying model representation.", value, this.getInputKey().getPrettyPrintableName());
                this.logError(msg);
            }
        }
    }

    @Override
    public boolean containsTuple(ITuple seed) {
        return this.values.containsNonZero(seed.get(0));
    }

    @Override
    public int countTuples(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() == 0) {
            return this.values.size();
        }
        Object value = seed.get(0);
        return this.values.containsNonZero(value) ? 1 : 0;
    }

    @Override
    public Iterable<Tuple> enumerateTuples(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() == 0) {
            return () -> this.values.distinctValues().stream().map(Tuples::staticArityFlatTupleOf).iterator();
        }
        Object value = seed.get(0);
        if (this.values.containsNonZero(value)) {
            return Collections.singleton(Tuples.staticArityFlatTupleOf(value));
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<? extends Object> enumerateValues(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() == 0) {
            return this.values;
        }
        throw new IllegalArgumentException(seedMask.toString());
    }
}

