/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.AbstractIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterGeneric;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IMemory;

public class DefaultIndexTable
extends AbstractIndexTable
implements ITableWriterGeneric {
    protected IMemory<Tuple> rows = CollectionsFactory.createMultiset();
    protected Map<TupleMask, MaskedTupleMemory> indexMemories = CollectionsFactory.createMap();
    private boolean unique;

    public DefaultIndexTable(IInputKey inputKey, ITableContext tableContext, boolean unique) {
        super(inputKey, tableContext);
        this.unique = unique;
    }

    @Override
    public void write(Direction direction, Tuple row) {
        block6: {
            block5: {
                if (direction != Direction.INSERT) break block5;
                boolean changed = this.rows.addOne(row);
                if (this.unique && !changed) {
                    String msg = String.format("Error: trying to add duplicate row %s to the unique table %s. This indicates some errors in underlying model representation.", row, this.getInputKey().getPrettyPrintableName());
                    this.logError(msg);
                }
                if (!changed) break block6;
                for (MaskedTupleMemory indexMemory : this.indexMemories.values()) {
                    indexMemory.add(row);
                }
                break block6;
            }
            boolean changed = this.rows.removeOne(row);
            if (this.unique && !changed) {
                String msg = String.format("Error: trying to remove duplicate value %s from the unique table %s. This indicates some errors in underlying model representation.", row, this.getInputKey().getPrettyPrintableName());
                this.logError(msg);
            }
            if (changed) {
                for (MaskedTupleMemory indexMemory : this.indexMemories.values()) {
                    indexMemory.remove(row);
                }
            }
        }
    }

    @Override
    public boolean containsTuple(ITuple seed) {
        return this.rows.distinctValues().contains(seed);
    }

    private MaskedTupleMemory getIndexMemory(TupleMask seedMask) {
        return this.indexMemories.computeIfAbsent(seedMask, mask -> {
            MaskedTupleMemory memory = MaskedTupleMemory.create(seedMask, CollectionsFactory.MemoryType.SETS, this);
            for (Tuple tuple : this.rows.distinctValues()) {
                memory.add(tuple);
            }
            return memory;
        });
    }

    @Override
    public int countTuples(TupleMask seedMask, ITuple seed) {
        switch (seedMask.getSize()) {
            case 0: {
                return this.rows.size();
            }
        }
        return this.getIndexMemory(seedMask).get(seed).size();
    }

    @Override
    public Iterable<Tuple> enumerateTuples(TupleMask seedMask, ITuple seed) {
        return this.getIndexMemory(seedMask).get(seed);
    }

    @Override
    public Iterable<? extends Object> enumerateValues(TupleMask seedMask, ITuple seed) {
        int queriedColumn = seedMask.getFirstOmittedIndex().getAsInt();
        return () -> this.getIndexMemory(seedMask).get(seed).stream().map(row2 -> row2.get(queriedColumn)).iterator();
    }
}

