/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.planning.helpers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlanFactory;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.FunctionalDependencyHelper;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PProject;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;

public class BuildHelper {
    private BuildHelper() {
    }

    public static SubPlan trimUnneccessaryVariables(SubPlanFactory planFactory, SubPlan plan, boolean onlyIfNotDetermined, QueryAnalyzer analyzer) {
        HashSet<PVariable> canBeTrimmed = new HashSet<PVariable>();
        Set<PVariable> variablesInPlan = plan.getVisibleVariables();
        for (PVariable trimCandidate : variablesInPlan) {
            if (!trimCandidate.getReferringConstraintsOfType(ExportedParameter.class).isEmpty() || !plan.getAllEnforcedConstraints().containsAll(trimCandidate.getReferringConstraints())) continue;
            canBeTrimmed.add(trimCandidate);
        }
        Set<PVariable> retainedVars = BuildHelper.setMinus(variablesInPlan, canBeTrimmed);
        if (!(canBeTrimmed.isEmpty() || onlyIfNotDetermined && BuildHelper.areVariablesDetermined(plan, retainedVars, canBeTrimmed, analyzer, false))) {
            plan = planFactory.createSubPlan(new PProject(retainedVars), plan);
        }
        return plan;
    }

    public static boolean areAllVariablesDetermined(SubPlan plan, Collection<PVariable> determining, QueryAnalyzer analyzer, boolean strict) {
        return BuildHelper.areVariablesDetermined(plan, determining, plan.getVisibleVariables(), analyzer, strict);
    }

    public static boolean areVariablesDetermined(SubPlan plan, Collection<PVariable> determining, Collection<PVariable> determined, QueryAnalyzer analyzer, boolean strict) {
        Map dependencies = analyzer.getFunctionalDependencies(plan.getAllEnforcedConstraints(), strict);
        Set<PVariable> closure = FunctionalDependencyHelper.closureOf(determining, dependencies);
        boolean isDetermined = closure.containsAll(determined);
        return isDetermined;
    }

    private static <T> Set<T> setMinus(Set<T> a, Set<T> b) {
        HashSet<T> difference = new HashSet<T>(a);
        difference.removeAll(b);
        return difference;
    }

    public static PConstraint getAnyUnenforcedConstraint(PBody pSystem, SubPlan plan) {
        Set<PConstraint> allEnforcedConstraints = plan.getAllEnforcedConstraints();
        Set<PConstraint> constraints = pSystem.getConstraints();
        for (PConstraint pConstraint : constraints) {
            if (allEnforcedConstraints.contains(pConstraint)) continue;
            return pConstraint;
        }
        return null;
    }

    public static void finalCheck(PBody pSystem, SubPlan plan, IQueryMetaContext context) {
        PConstraint unenforcedConstraint = BuildHelper.getAnyUnenforcedConstraint(pSystem, plan);
        if (unenforcedConstraint != null) {
            throw new QueryProcessingException("Pattern matcher construction terminated without successfully enforcing constraint {1}. Could be caused if the value of some variables can not be deduced, e.g. by circularity of pattern constraints.", new String[]{unenforcedConstraint.toString()}, "Could not enforce a pattern constraint", null);
        }
        for (ExportedParameter export : pSystem.getConstraintsOfType(ExportedParameter.class)) {
            if (export.isReadyAt(plan, context)) continue;
            throw new QueryProcessingException("Exported pattern parameter {1} could not be deduced during pattern matcher construction. A pattern constraint is required to positively deduce its value.", new String[]{export.getParameterName()}, "Could not calculate pattern parameter", null);
        }
    }
}

