/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser;

import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpression;

public class FilterExpression
implements Predicate<Map<String, String>> {
    private Queue<Object> fElements;

    public FilterExpression(Queue<Object> elements) {
        this.fElements = elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(Map<String, String> data) {
        if (this.fElements == null || this.fElements.isEmpty()) {
            return false;
        }
        int index = 0;
        boolean result = false;
        String operator = "||";
        while (!this.fElements.isEmpty()) {
            Object element = this.fElements.poll();
            if (index % 2 == 0) {
                Predicate<Map<String, String>> expression;
                if (element instanceof FilterSimpleExpression) {
                    expression = (FilterSimpleExpression)element;
                    result = FilterExpression.handleOperator(result, operator, ((FilterSimpleExpression)expression).test(data));
                } else {
                    if (!(element instanceof FilterExpression)) return false;
                    expression = (FilterExpression)element;
                    result = FilterExpression.handleOperator(result, operator, ((FilterExpression)expression).test(data));
                }
            } else {
                if (!(element instanceof String)) {
                    return false;
                }
                operator = (String)element;
            }
            ++index;
        }
        return result;
    }

    private static boolean handleOperator(boolean left, String operator, boolean right) {
        return operator.equals("||") ? left || right : left && right;
    }
}

