/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class CompareRevertOperation
extends CVSSubscriberOperation {
    protected CompareRevertOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    protected String getJobName() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return NLS.bind((String)CVSUIMessages.CompareRevertAction_0, (Object[])new String[]{Integer.valueOf(syncSet.size()).toString()});
    }

    @Override
    protected void runWithProjectRule(IProject project, SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        SyncInfo[] changed = syncSet.getSyncInfos();
        if (changed.length == 0) {
            return;
        }
        if (!this.promptForOverwrite(syncSet)) {
            return;
        }
        ArrayList<SyncInfo> updateShallow = new ArrayList<SyncInfo>();
        HashSet<SyncInfo> parentCreationElements = new HashSet<SyncInfo>();
        int i = 0;
        while (i < changed.length) {
            IResource resource;
            SyncInfo changedNode = changed[i];
            SyncInfo parent = this.getParent(changedNode);
            if (parent != null && this.isOutOfSync(parent)) {
                parentCreationElements.add(parent);
            }
            if ((resource = changedNode.getLocal()).getType() == 1) {
                if (changedNode.getLocal().exists()) {
                    updateShallow.add(changedNode);
                } else if (changedNode.getRemote() != null) {
                    updateShallow.add(changedNode);
                }
            } else if (this.isOutOfSync(changedNode)) {
                parentCreationElements.add(changedNode);
            }
            ++i;
        }
        try {
            monitor.beginTask(null, 100);
            if (parentCreationElements.size() > 0) {
                this.makeInSync(parentCreationElements.toArray(new SyncInfo[parentCreationElements.size()]), Policy.subMonitorFor(monitor, 25));
            }
            if (updateShallow.size() > 0) {
                this.runUpdate(updateShallow.toArray(new SyncInfo[updateShallow.size()]), Policy.subMonitorFor(monitor, 75));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void runUpdate(SyncInfo[] infos, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100 * infos.length);
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            this.makeRemoteLocal(info, Policy.subMonitorFor(monitor, 100));
            ++i;
        }
        monitor.done();
    }
}

