/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.IStringMapping;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.ui.AlternateUserValidationDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.ConfigureRepositoryLocationsDialog;
import org.eclipse.team.internal.ccvs.ui.KeyboardInteractiveDialog;
import org.eclipse.team.internal.ccvs.ui.UserValidationDialog;

public class WorkbenchUserAuthenticator
implements IUserAuthenticator {
    public static boolean USE_ALTERNATE_PROMPTER = false;

    public WorkbenchUserAuthenticator() {
        IIgnoreInfo[] ignores = Team.getAllIgnores();
        boolean found = false;
        int i = 0;
        while (i < ignores.length) {
            if (ignores[i].getPattern().equals("*.notes")) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            return;
        }
        IStringMapping[] mappings = Team.getFileContentManager().getExtensionMappings();
        int i2 = 0;
        while (i2 < mappings.length) {
            if (mappings[i2].getString().equals("notes")) {
                USE_ALTERNATE_PROMPTER = true;
                return;
            }
            ++i2;
        }
        USE_ALTERNATE_PROMPTER = false;
    }

    public void promptForUserInfo(final ICVSRepositoryLocation location, final IUserInfo userinfo, final String message) throws CVSException {
        if (!userinfo.isUsernameMutable() && USE_ALTERNATE_PROMPTER) {
            this.alternatePromptForUserInfo(userinfo);
            return;
        }
        final String[] result = new String[2];
        Display display = Display.getCurrent();
        final boolean[] allowCaching = new boolean[1];
        if (display != null) {
            allowCaching[0] = this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
        } else {
            final CVSException[] exception = new CVSException[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        allowCaching[0] = WorkbenchUserAuthenticator.this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
                    }
                    catch (CVSException e) {
                        exception[0] = e;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        if (result[0] == null) {
            throw new OperationCanceledException(CVSUIMessages.WorkbenchUserAuthenticator_cancelled);
        }
        if (userinfo.isUsernameMutable()) {
            userinfo.setUsername(result[0]);
        }
        userinfo.setPassword(result[1]);
        if (location != null) {
            if (userinfo.isUsernameMutable()) {
                location.setUsername(result[0]);
            }
            location.setPassword(result[1]);
            location.setAllowCaching(allowCaching[0]);
        }
    }

    private boolean promptForPassword(ICVSRepositoryLocation location, String username, String message, boolean userMutable, String[] result) throws CVSException {
        String host;
        int index;
        String domain = location == null ? null : location.getLocation(true);
        boolean cachingCheckbox = true;
        if (location != null && location.getMethod().getName().equals("pserverssh2") && (index = (host = location.getHost()).indexOf("@")) != -1) {
            cachingCheckbox = false;
            if (index != 0 && !username.equals(host.substring(0, index))) {
                cachingCheckbox = true;
            }
        }
        UserValidationDialog dialog = new UserValidationDialog(null, domain, username == null ? "" : username, message, cachingCheckbox);
        dialog.setUsernameMutable(userMutable);
        dialog.open();
        result[0] = dialog.getUsername();
        result[1] = dialog.getPassword();
        return dialog.getAllowCaching();
    }

    public String[] promptForKeyboradInteractive(final ICVSRepositoryLocation location, final String destination, final String name, final String instruction, final String[] prompt, final boolean[] echo) throws CVSException {
        final String[][] result = new String[1][];
        final boolean[] allowCaching = new boolean[1];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this._promptForUserInteractive(location, destination, name, instruction, prompt, echo, allowCaching);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = WorkbenchUserAuthenticator.this._promptForUserInteractive(location, destination, name, instruction, prompt, echo, allowCaching);
                }
            });
        }
        if (result[0] != null && location != null && KeyboardInteractiveDialog.isPasswordAuth(prompt)) {
            location.setPassword(result[0][0]);
            location.setAllowCaching(allowCaching[0]);
        }
        return result[0];
    }

    private String[] _promptForUserInteractive(ICVSRepositoryLocation location, String destination, String name, String instruction, String[] prompt, boolean[] echo, boolean[] allowCaching) {
        String host;
        int index;
        String domain = location == null ? null : location.getLocation(true);
        String userName = location == null ? null : location.getUsername();
        boolean cachingCheckbox = true;
        if (location != null && location.getMethod().getName().equals("pserverssh2") && (index = (host = location.getHost()).indexOf("@")) != -1) {
            if (index != 0) {
                userName = host.substring(0, index);
            }
            cachingCheckbox = false;
        }
        KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, domain, destination, name, userName, instruction, prompt, echo, cachingCheckbox);
        dialog.open();
        String[] _result = dialog.getResult();
        if (_result != null) {
            allowCaching[0] = dialog.getAllowCaching();
        }
        return _result;
    }

    private String alternatePromptForPassword(String username) {
        AlternateUserValidationDialog dialog = new AlternateUserValidationDialog(null, username == null ? "" : username);
        dialog.setUsername(username);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        return dialog.getPassword();
    }

    public void alternatePromptForUserInfo(final IUserInfo userinfo) {
        final String[] result = new String[1];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this.alternatePromptForPassword(userinfo.getUsername());
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = WorkbenchUserAuthenticator.this.alternatePromptForPassword(userinfo.getUsername());
                }
            });
        }
        if (result[0] == null) {
            throw new OperationCanceledException(CVSUIMessages.WorkbenchUserAuthenticator_The_operation_was_canceled_by_the_user_1);
        }
        userinfo.setPassword(result[0]);
    }

    public int prompt(final ICVSRepositoryLocation location, final int promptType, final String title, final String message, int[] promptResponses, int defaultResponse) {
        final Display display = CVSUIPlugin.getStandardDisplay();
        final int[] retval = new int[1];
        final String[] buttons = new String[promptResponses.length];
        int i = 0;
        while (i < promptResponses.length) {
            int prompt = promptResponses[i];
            switch (prompt) {
                case 0: {
                    buttons[i] = IDialogConstants.OK_LABEL;
                    break;
                }
                case 1: {
                    buttons[i] = IDialogConstants.CANCEL_LABEL;
                    break;
                }
                case 3: {
                    buttons[i] = IDialogConstants.NO_LABEL;
                    break;
                }
                case 2: {
                    buttons[i] = IDialogConstants.YES_LABEL;
                }
            }
            ++i;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(new Shell(display), title, null, NLS.bind((String)CVSUIMessages.WorkbenchUserAuthenticator_0, (Object)message, (Object)location.getLocation(true)), promptType, buttons, 1);
                retval[0] = dialog.open();
            }
        });
        return retval[0];
    }

    public boolean promptForHostKeyChange(final ICVSRepositoryLocation location) {
        final boolean[] openConfirm = new boolean[1];
        Display display = CVSUIPlugin.getStandardDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                openConfirm[0] = MessageDialog.openConfirm(null, (String)CVSUIMessages.WorkbenchUserAuthenticator_1, (String)NLS.bind((String)CVSUIMessages.WorkbenchUserAuthenticator_2, (Object[])new String[]{location.getHost()}));
            }
        });
        if (!openConfirm[0]) {
            throw new OperationCanceledException();
        }
        return openConfirm[0];
    }

    public Map promptToConfigureRepositoryLocations(final Map alternativeMap) {
        final Map[] result = new Map[1];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this.openAlternativeRepositoryDialog(alternativeMap);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = WorkbenchUserAuthenticator.this.openAlternativeRepositoryDialog(alternativeMap);
                }
            });
        }
        return result[0];
    }

    private Map openAlternativeRepositoryDialog(Map alternativeMap) {
        ConfigureRepositoryLocationsDialog dialog = new ConfigureRepositoryLocationsDialog(null, alternativeMap);
        int result = dialog.open();
        return result == 1 ? null : dialog.getSelected();
    }
}

