/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.AdaptableResourceList;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AddToVersionControlDialog
extends DetailsDialog {
    private static final int WIDTH_HINT = 350;
    private static final int SELECTION_HEIGHT_HINT = 100;
    private IResource[] unaddedResources;
    private Object[] resourcesToAdd;
    private CheckboxTableViewer listViewer;

    public AddToVersionControlDialog(Shell parentShell, IResource[] unaddedResources) {
        super(parentShell, CVSUIMessages.AddToVersionControlDialog_title);
        this.unaddedResources = unaddedResources;
    }

    protected void createMainDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        if (this.unaddedResources.length == 1) {
            this.createWrappingLabel(composite, NLS.bind((String)CVSUIMessages.AddToVersionControlDialog_thereIsAnUnaddedResource, (Object[])new String[]{Integer.valueOf(this.unaddedResources.length).toString()}));
        } else {
            this.createWrappingLabel(composite, NLS.bind((String)CVSUIMessages.AddToVersionControlDialog_thereAreUnaddedResources, (Object[])new String[]{Integer.valueOf(this.unaddedResources.length).toString()}));
        }
    }

    protected String getHelpContextId() {
        return "org.eclipse.team.cvs.ui.add_to_version_control_dialog_context";
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.addUnaddedResourcesArea(composite);
        return composite;
    }

    private void addUnaddedResourcesArea(Composite composite) {
        this.createWrappingLabel(composite, CVSUIMessages.ReleaseCommentDialog_unaddedResources);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 350;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getFullPath().toString();
                }
                return input;
            }
        });
        this.listViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.listViewer.setInput((Object)new AdaptableResourceList(this.unaddedResources));
        if (this.resourcesToAdd == null) {
            this.listViewer.setAllChecked(true);
        } else {
            this.listViewer.setCheckedElements(this.resourcesToAdd);
        }
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddToVersionControlDialog.this.resourcesToAdd = AddToVersionControlDialog.this.listViewer.getCheckedElements();
            }
        });
        this.addSelectionButtons(composite);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, CVSUIMessages.ReleaseCommentDialog_selectAll, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddToVersionControlDialog.this.listViewer.setAllChecked(true);
                AddToVersionControlDialog.this.resourcesToAdd = null;
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, CVSUIMessages.ReleaseCommentDialog_deselectAll, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddToVersionControlDialog.this.listViewer.setAllChecked(false);
                AddToVersionControlDialog.this.resourcesToAdd = new Object[0];
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected void updateEnablements() {
    }

    public IResource[] getResourcesToAdd() {
        if (this.resourcesToAdd == null) {
            return this.unaddedResources;
        }
        List<Object> result = Arrays.asList(this.resourcesToAdd);
        return result.toArray(new IResource[result.size()]);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
        this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
        super.createButtonsForButtonBar(parent);
    }

    protected boolean includeOkButton() {
        return false;
    }

    protected void buttonPressed(int id) {
        if (id == 2 || id == 3) {
            this.setReturnCode(id);
            this.close();
        } else {
            super.buttonPressed(id);
        }
    }
}

