/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description.util;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.business.internal.migration.description.VSMVersionSAXParser;
import org.eclipse.sirius.viewpoint.description.util.DescriptionResourceImpl;
import org.osgi.framework.Version;

public class DescriptionResourceFactoryImpl
extends ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        VSMVersionSAXParser parser = new VSMVersionSAXParser(uri);
        String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        boolean migrationIsNeeded = true;
        if (loadedVersion != null) {
            migrationIsNeeded = VSMMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)loadedVersion));
        }
        DescriptionResourceImpl resource = new DescriptionResourceImpl(uri);
        HashMap<Object, Object> loadOptions = new HashMap<Object, Object>();
        loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        saveOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        if (migrationIsNeeded) {
            DescriptionResourceImpl.addMigrationOptions(loadedVersion, loadOptions, saveOptions);
        }
        resource.getDefaultLoadOptions().putAll(loadOptions);
        resource.getDefaultSaveOptions().putAll(saveOptions);
        return resource;
    }
}

