/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.menu.refactoring.border;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.tools.api.menu.AbstractEObjectRefactoringAction;
import org.eclipse.sirius.editor.tools.api.menu.AbstractUndoRecordingCommand;
import org.eclipse.sirius.viewpoint.description.RepresentationTemplate;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.IEditorPart;

public class MaterializeTemplateRefactoring
extends AbstractEObjectRefactoringAction {
    private static final String MATERIALIZE_TEMPLATE_COMMAND_LABEL = "Transform Template to Representations";

    public MaterializeTemplateRefactoring(IEditorPart editor, ISelection selection) {
        super(editor, selection);
    }

    @Override
    protected Command buildActionCommand(EditingDomain arg0, Collection<EObject> selection) {
        EObject elementToMove;
        Object result = UnexecutableCommand.INSTANCE;
        this.setSelectionValid(false);
        if (selection.size() == 1 && (elementToMove = selection.iterator().next()) instanceof RepresentationTemplate && elementToMove.eContainer() instanceof Viewpoint) {
            this.setSelectionValid(true);
            this.setTextIfDisable(MATERIALIZE_TEMPLATE_COMMAND_LABEL);
            final RepresentationTemplate template = (RepresentationTemplate)elementToMove;
            final Viewpoint containingSirius = (Viewpoint)template.eContainer();
            result = new AbstractUndoRecordingCommand(arg0.getResourceSet()){

                @Override
                protected void doExecute() {
                    containingSirius.getOwnedRepresentations().addAll((Collection)template.getOwnedRepresentations());
                    EcoreUtil.delete((EObject)template);
                }

                @Override
                protected String getText() {
                    return MaterializeTemplateRefactoring.MATERIALIZE_TEMPLATE_COMMAND_LABEL;
                }
            };
        }
        return result;
    }
}

