/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceProxy;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.def.ServiceDef;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.SetFactory;

public final class PartServiceContext
extends ServiceContext {
    private final ISapphirePart part;

    public PartServiceContext(ISapphirePart part) {
        super("Sapphire.Part", Sapphire.services());
        this.part = part;
    }

    public <T> T find(Class<T> type) {
        Object obj = super.find(type);
        if (obj == null) {
            Element element;
            if (type.isInstance(this.part)) {
                obj = type.cast(this.part);
            } else if (Element.class.isAssignableFrom(type) && (element = this.part.getLocalModelElement()) != null) {
                obj = type == Element.class ? type.cast(element) : element.nearest(type);
            }
        }
        return (T)obj;
    }

    protected List<ServiceProxy> local() {
        ListFactory local = ListFactory.start();
        PartDef partDef = this.part.definition();
        for (ServiceDef serviceDef : partDef.getServices()) {
            Class serviceImplClass = PartServiceContext.resolve(serviceDef.getImplementation());
            if (serviceImplClass == null) continue;
            SetFactory overridesSetFactory = SetFactory.start();
            for (ServiceDef.Override override : serviceDef.getOverrides()) {
                String id = override.getId().text();
                if (id == null || (id = id.trim()).length() <= 0) continue;
                overridesSetFactory.add((Object)id);
            }
            local.add((Object)new ServiceProxy((ServiceContext)this, serviceImplClass.getName(), serviceImplClass, null, overridesSetFactory.result(), null));
        }
        return local.result();
    }

    private static <T> Class<T> resolve(ReferenceValue<JavaTypeName, JavaType> ref) {
        JavaType type = (JavaType)ref.target();
        return type != null ? (Class)type.artifact() : null;
    }
}

