/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDefaultEvent;
import org.eclipse.sapphire.Serialization;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;

public final class TextOverlayPainter {
    private static final Point TEXT_OFFSET;
    private final Display display;
    private final Text textControl;
    private final Value<?> property;
    private final boolean isSensitiveData;
    private final Serialization serialization;
    private final JumpActionHandler jumpActionHandler;
    private final Presentation presentation;
    private boolean controlKeyActive;
    private Point textExtent;
    private boolean hyperlinkActive;
    private boolean mouseOverText;

    static {
        String os = Platform.getOS();
        TEXT_OFFSET = os.equals("win32") ? new Point(4, 1) : new Point(2, 2);
    }

    private TextOverlayPainter(Text textControl, Value<?> property, JumpActionHandler jumpActionHandler, Presentation presentation) {
        ValueProperty pdef = property.definition();
        this.display = textControl.getDisplay();
        this.textControl = textControl;
        this.property = property;
        this.isSensitiveData = pdef.hasAnnotation(SensitiveData.class);
        this.serialization = (Serialization)pdef.getAnnotation(Serialization.class);
        this.jumpActionHandler = jumpActionHandler;
        this.presentation = presentation;
        this.controlKeyActive = false;
        this.hyperlinkActive = false;
        this.mouseOverText = false;
        final org.eclipse.swt.widgets.Listener keyListener = new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handleKeyEvent(event);
            }
        };
        this.display.addFilter(1, keyListener);
        this.display.addFilter(2, keyListener);
        this.textControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TextOverlayPainter.this.display.removeFilter(1, keyListener);
                TextOverlayPainter.this.display.removeFilter(2, keyListener);
            }
        });
        this.textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextOverlayPainter.this.updateTextExtent();
            }
        });
        this.updateTextExtent();
        this.textControl.addListener(9, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handlePaint(event);
            }
        });
        this.textControl.addListener(5, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handleMouseMove(event);
            }
        });
        this.textControl.addListener(7, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handleMouseExit(event);
            }
        });
        this.textControl.addListener(3, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handleMouseDown(event);
            }
        });
        FilteredListener<PropertyDefaultEvent> propertyListener = new FilteredListener<PropertyDefaultEvent>(){

            protected void handleTypedEvent(PropertyDefaultEvent event) {
                SwtUtil.runOnDisplayThread(new Runnable(){

                    @Override
                    public void run() {
                        TextOverlayPainter.this.textControl.redraw();
                    }
                });
            }
        };
        this.property.attach((Listener)propertyListener);
        this.textControl.addDisposeListener(new DisposeListener((FilteredListener)propertyListener){
            private final /* synthetic */ FilteredListener val$propertyListener;
            {
                this.val$propertyListener = filteredListener;
            }

            public void widgetDisposed(DisposeEvent event) {
                TextOverlayPainter.this.property.detach((Listener)this.val$propertyListener);
            }
        });
    }

    public static void install(Text textControl, Value<?> property) {
        TextOverlayPainter.install(textControl, property, null, null);
    }

    public static void install(Text textControl, Value<?> property, JumpActionHandler jumpActionHandler, Presentation presentation) {
        new TextOverlayPainter(textControl, property, jumpActionHandler, presentation);
    }

    private void handleKeyEvent(Event event) {
        if (event.keyCode == 262144) {
            boolean bl = this.controlKeyActive = event.type == 1;
            if (!this.controlKeyActive) {
                this.update();
            }
        }
    }

    private void handleMouseMove(Event event) {
        this.mouseOverText = event.x <= this.textExtent.x && event.y <= this.textExtent.y;
        this.update();
    }

    private void handleMouseExit(Event event) {
        this.mouseOverText = false;
        this.update();
    }

    private void handleMouseDown(Event event) {
        if (this.hyperlinkActive) {
            this.textControl.setCursor(null);
            this.handleJumpCommand();
        }
    }

    private boolean isJumpEnabled() {
        return this.jumpActionHandler == null ? false : this.jumpActionHandler.isEnabled();
    }

    private void handleJumpCommand() {
        Runnable op = new Runnable(){

            @Override
            public void run() {
                TextOverlayPainter.this.jumpActionHandler.execute(TextOverlayPainter.this.presentation);
            }
        };
        BusyIndicator.showWhile((Display)this.display, (Runnable)op);
    }

    private String overlay() {
        String def;
        String string = def = this.property.disposed() ? null : this.property.getDefaultText();
        if (def != null && this.isSensitiveData) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            int n = def.length();
            while (i < n) {
                buf.append("\u25cf");
                ++i;
            }
            def = buf.toString();
        }
        if (def == null && this.serialization != null) {
            def = this.serialization.primary();
        }
        return def;
    }

    private void update() {
        boolean shouldHyperlinkBeActive;
        boolean bl = shouldHyperlinkBeActive = this.controlKeyActive && this.mouseOverText && this.isJumpEnabled();
        if (this.hyperlinkActive != shouldHyperlinkBeActive) {
            this.hyperlinkActive = shouldHyperlinkBeActive;
            this.textControl.setCursor(shouldHyperlinkBeActive ? this.display.getSystemCursor(21) : null);
            this.textControl.redraw();
        }
    }

    private void updateTextExtent() {
        GC gc = new GC((Drawable)this.textControl);
        this.textExtent = gc.textExtent(this.getTextWithOverlay());
        gc.dispose();
    }

    private void handlePaint(Event event) {
        if (this.textControl.isEnabled()) {
            String overlay;
            if (this.hyperlinkActive) {
                TextStyle style = new TextStyle(this.textControl.getFont(), null, null);
                style.underline = true;
                style.underlineColor = style.foreground = JFaceColors.getActiveHyperlinkText((Display)this.display);
                this.paintTextOverlay(event.gc, style, this.getTextWithOverlay());
            } else if (!this.textControl.isFocusControl() && this.textControl.getText().length() == 0 && (overlay = this.overlay()) != null && overlay.length() > 0) {
                TextStyle style = new TextStyle(this.textControl.getFont(), null, null);
                style.foreground = this.display.getSystemColor(15);
                this.paintTextOverlay(event.gc, style, overlay);
            }
        }
    }

    private void paintTextOverlay(GC gc, TextStyle style, String text) {
        TextLayout layout = new TextLayout((Device)this.display);
        layout.setText(text);
        layout.setStyle(style, 0, text.length() - 1);
        Rectangle clientArea = this.textControl.getClientArea();
        gc.fillRectangle(clientArea);
        layout.setWidth(clientArea.width - TextOverlayPainter.TEXT_OFFSET.x * 2);
        layout.draw(gc, TextOverlayPainter.TEXT_OFFSET.x, TextOverlayPainter.TEXT_OFFSET.y);
    }

    private String getTextWithOverlay() {
        String text = this.textControl.getText();
        if (text.length() == 0 && (text = this.overlay()) == null) {
            text = "";
        }
        return text;
    }
}

