/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.ProblemOverlayImageDescriptor;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class SwtResourceCache
implements Disposable {
    private final Map<ImageDescriptor, ImageHandle> imageDescToImageHandle = new HashMap<ImageDescriptor, ImageHandle>();
    private final Map<ImageData, ImageDescriptor> imageDataToImageDesc = new HashMap<ImageData, ImageDescriptor>();
    private final Map<Color, org.eclipse.swt.graphics.Color> colors = new HashMap<Color, org.eclipse.swt.graphics.Color>();

    public Image image(ImageDescriptor imageDescriptor) {
        return this.image(imageDescriptor, Status.Severity.OK);
    }

    public Image image(ImageDescriptor imageDescriptor, Status.Severity problemSeverity) {
        ImageHandle imageHandle = this.imageDescToImageHandle.get(imageDescriptor);
        if (imageHandle == null) {
            imageHandle = new ImageHandle(imageDescriptor);
            this.imageDescToImageHandle.put(imageDescriptor, imageHandle);
        }
        return imageHandle.getImage(problemSeverity);
    }

    public Image image(ElementType type) {
        return this.image(type.image());
    }

    public Image image(ImageData imageData) {
        return this.image(imageData, Status.Severity.OK);
    }

    public Image image(ImageData imageData, Status.Severity severity) {
        if (imageData != null) {
            ImageDescriptor imageDescriptor = this.imageDataToImageDesc.get(imageData);
            if (imageDescriptor == null) {
                imageDescriptor = SwtUtil.toImageDescriptor(imageData);
                this.imageDataToImageDesc.put(imageData, imageDescriptor);
            }
            return this.image(imageDescriptor, severity);
        }
        return null;
    }

    public org.eclipse.swt.graphics.Color color(Color color) {
        return this.color(color, null);
    }

    public org.eclipse.swt.graphics.Color color(Color color, Color def) {
        Color sapphireColor;
        Color color2 = sapphireColor = color == null ? def : color;
        if (sapphireColor != null) {
            org.eclipse.swt.graphics.Color swtColor = this.colors.get(sapphireColor);
            if (swtColor == null) {
                swtColor = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), sapphireColor.red(), sapphireColor.green(), sapphireColor.blue());
                this.colors.put(sapphireColor, swtColor);
            }
            return swtColor;
        }
        return null;
    }

    public void dispose() {
        for (ImageHandle imageHandle : this.imageDescToImageHandle.values()) {
            imageHandle.dispose();
        }
        for (org.eclipse.swt.graphics.Color color : this.colors.values()) {
            color.dispose();
        }
    }

    private static final class ImageHandle {
        private final ImageDescriptor baseImageDescriptor;
        private Image baseImage;
        private Image warningImage;
        private Image errorImage;

        public ImageHandle(ImageDescriptor baseImageDescriptor) {
            this.baseImageDescriptor = baseImageDescriptor;
        }

        public Image getImage(Status.Severity severity) {
            if (this.baseImageDescriptor == null) {
                return null;
            }
            if (severity == Status.Severity.ERROR) {
                if (this.errorImage == null) {
                    ProblemOverlayImageDescriptor desc = new ProblemOverlayImageDescriptor(this.baseImageDescriptor, Status.Severity.ERROR);
                    this.errorImage = desc.createImage();
                }
                return this.errorImage;
            }
            if (severity == Status.Severity.WARNING) {
                if (this.warningImage == null) {
                    ProblemOverlayImageDescriptor desc = new ProblemOverlayImageDescriptor(this.baseImageDescriptor, Status.Severity.WARNING);
                    this.warningImage = desc.createImage();
                }
                return this.warningImage;
            }
            if (this.baseImage == null) {
                this.baseImage = this.baseImageDescriptor.createImage();
            }
            return this.baseImage;
        }

        public void dispose() {
            if (this.baseImage != null) {
                this.baseImage.dispose();
            }
            if (this.errorImage != null) {
                this.errorImage.dispose();
            }
            if (this.warningImage != null) {
                this.warningImage.dispose();
            }
        }
    }
}

