/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class ListFunction
extends Function {
    @Override
    public String name() {
        return "List";
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                int size = this.operands().size();
                if (size == 0) {
                    return Collections.emptyList();
                }
                if (size == 1) {
                    return Collections.singletonList(this.operand(0));
                }
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while (i < size) {
                    list.add(this.operand(i));
                    ++i;
                }
                return list;
            }
        };
    }
}

