/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;

public final class ConcatFunction
extends Function {
    public static ConcatFunction create(List<Function> operands) {
        ConcatFunction function = new ConcatFunction();
        function.init(operands);
        return function;
    }

    public static ConcatFunction create(Function a, Function b) {
        ConcatFunction function = new ConcatFunction();
        function.init(a, b);
        return function;
    }

    public static ConcatFunction create(String a, String b) {
        return ConcatFunction.create((Function)Literal.create(a), (Function)Literal.create(b));
    }

    public static ConcatFunction create(Function a, String b) {
        return ConcatFunction.create(a, (Function)Literal.create(b));
    }

    public static ConcatFunction create(String a, Function b) {
        return ConcatFunction.create((Function)Literal.create(a), b);
    }

    @Override
    public String name() {
        return "Concat";
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                StringBuilder buf = new StringBuilder();
                for (FunctionResult operand : this.operands()) {
                    buf.append(this.cast(operand.value(), String.class));
                }
                return buf.toString();
            }
        };
    }

    @Override
    public void toString(StringBuilder buf, boolean topLevel) {
        if (topLevel) {
            for (Function operand : this.operands()) {
                if (operand instanceof Literal) {
                    operand.toString(buf, true);
                    continue;
                }
                buf.append("$( ");
                operand.toString(buf, false);
                buf.append(" }");
            }
        } else {
            super.toString(buf, topLevel);
        }
    }
}

