/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.internal.FunctionUtils;

public final class AddFunction
extends Function {
    public static AddFunction create(Function a, Function b) {
        AddFunction function = new AddFunction();
        function.init(a, b);
        return function;
    }

    public static AddFunction create(Number a, Number b) {
        return AddFunction.create(Literal.create(a), Literal.create(b));
    }

    @Override
    public String name() {
        return "+";
    }

    @Override
    public boolean operator() {
        return true;
    }

    @Override
    public int precedence() {
        return 4;
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                Object b;
                Object a = this.operand(0);
                if (a instanceof Value) {
                    a = ((Value)a).content();
                }
                if ((b = this.operand(1)) instanceof Value) {
                    b = ((Value)b).content();
                }
                if (a == null && b == null) {
                    return 0L;
                }
                if (a instanceof BigDecimal || b instanceof BigDecimal) {
                    BigDecimal x = this.cast(a, BigDecimal.class);
                    BigDecimal y = this.cast(b, BigDecimal.class);
                    return x.add(y);
                }
                if (a instanceof Float || a instanceof Double || FunctionUtils.isDecimalString(a) || b instanceof Float || b instanceof Double || FunctionUtils.isDecimalString(b)) {
                    if (a instanceof BigInteger || b instanceof BigInteger) {
                        BigDecimal x = this.cast(a, BigDecimal.class);
                        BigDecimal y = this.cast(b, BigDecimal.class);
                        return x.add(y);
                    }
                    Double x = this.cast(a, Double.class);
                    Double y = this.cast(b, Double.class);
                    return x + y;
                }
                if (a instanceof BigInteger || b instanceof BigInteger) {
                    BigInteger x = this.cast(a, BigInteger.class);
                    BigInteger y = this.cast(b, BigInteger.class);
                    return x.add(y);
                }
                Long x = this.cast(a, Long.class);
                Long y = this.cast(b, Long.class);
                return x + y;
            }
        };
    }
}

