/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValueLabelService;

public final class EnumValueLabelService
extends ValueLabelService {
    private EnumValueType enumType;

    @Override
    protected void init() {
        super.init();
        this.enumType = new EnumValueType(this.context(ValueProperty.class).getTypeClass());
    }

    @Override
    public String provide(String value) {
        MasterConversionService masterConversionService = this.context(ValueProperty.class).service(MasterConversionService.class);
        Enum<?> item = masterConversionService.convert(value, this.enumType.getEnumTypeClass());
        if (item == null) {
            return value;
        }
        return this.enumType.getLabel(item, false, CapitalizationType.NO_CAPS, false);
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && Enum.class.isAssignableFrom(property.getTypeClass());
        }
    }
}

