/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.internal.ElementClassLoader;

public final class ElementClassLoaders {
    private static final Map<ClassLoader, ElementClassLoader> loaders = new WeakHashMap<ClassLoader, ElementClassLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadImplementationClass(ElementType type) {
        final ClassLoader typeInterfaceClassLoader = type.getModelElementClass().getClassLoader();
        Class<ElementClassLoaders> clazz = ElementClassLoaders.class;
        synchronized (ElementClassLoaders.class) {
            ElementClassLoader loader = loaders.get(typeInterfaceClassLoader);
            if (loader == null) {
                loader = AccessController.doPrivileged(new PrivilegedAction<ElementClassLoader>(){

                    @Override
                    public ElementClassLoader run() {
                        return new ElementClassLoader(typeInterfaceClassLoader);
                    }
                });
                loaders.put(typeInterfaceClassLoader, loader);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return loader.loadImplementationClass(type);
        }
    }

    private ElementClassLoaders() {
    }
}

