/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValueLabelService;

public final class DefaultValueLabelService
extends ValueLabelService {
    @Override
    public String provide(String text) {
        String decoded;
        ValueProperty property = this.context(ValueProperty.class);
        String label = decoded = property.decodeKeywords(text);
        ValueKeyword keyword = property.getKeyword(property.encodeKeywords(decoded));
        if (keyword != null) {
            label = keyword.toDisplayString();
        } else if (property.hasAnnotation(NamedValues.class)) {
            LocalizationService localization = property.getLocalizationService();
            NamedValues.NamedValue[] namedValueArray = property.getAnnotation(NamedValues.class).namedValues();
            int n = namedValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                NamedValues.NamedValue x = namedValueArray[n2];
                if (decoded.equals(x.value())) {
                    label = String.valueOf(localization.text(x.label(), CapitalizationType.NO_CAPS, false)) + " (" + x.value() + ")";
                    break;
                }
                ++n2;
            }
        }
        return label;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            return context.find(ValueProperty.class) != null;
        }
    }
}

