/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PossibleTypesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.LayeredElementBindingImpl;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public class StandardXmlElementBindingImpl
extends LayeredElementBindingImpl {
    @Text(value="{0}.{1} : {2}")
    private static LocalizableText failure;
    @Text(value="Element name must be specified in @XmlElementBinding.Mapping annotation.")
    private static LocalizableText mustSpecifyElementNameMsg;
    private PossibleTypesService possibleTypesService;
    private Listener possibleTypesServiceListener;
    private XmlPath path;
    private QName[] xmlElementNames;
    private ElementType[] modelElementTypes;

    static {
        LocalizableText.init(StandardXmlElementBindingImpl.class);
    }

    public void init(Property property) {
        super.init(property);
        this.possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
        this.possibleTypesServiceListener = new Listener(){

            public void handle(Event event) {
                StandardXmlElementBindingImpl.this.initBindingMetadata();
            }
        };
        this.possibleTypesService.attach(this.possibleTypesServiceListener);
        this.initBindingMetadata();
    }

    private void initBindingMetadata() {
        Element element = this.property().element();
        PropertyDef property = this.property().definition();
        try {
            XmlElementBinding xmlElementBindingAnnotation = (XmlElementBinding)property.getAnnotation(XmlElementBinding.class);
            XmlNamespaceResolver xmlNamespaceResolver = ((XmlResource)element.resource()).getXmlNamespaceResolver();
            Set possible = this.possibleTypesService.types();
            this.modelElementTypes = possible.toArray(new ElementType[possible.size()]);
            if (xmlElementBindingAnnotation == null) {
                XmlBinding xmlBindingAnnotation = (XmlBinding)property.getAnnotation(XmlBinding.class);
                if (xmlBindingAnnotation != null && possible.size() == 1) {
                    String path = xmlBindingAnnotation.path();
                    int slashIndex = path.lastIndexOf(47);
                    if (slashIndex == -1) {
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName(path, xmlNamespaceResolver)};
                    } else if (slashIndex > 0 && slashIndex < path.length() - 1) {
                        this.path = new XmlPath(path.substring(0, slashIndex), xmlNamespaceResolver);
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName(path.substring(slashIndex + 1), xmlNamespaceResolver)};
                    }
                }
                if (this.xmlElementNames == null) {
                    this.path = new XmlPath(property.name(), ((XmlResource)element.resource()).getXmlNamespaceResolver());
                    this.xmlElementNames = new QName[this.modelElementTypes.length];
                    int i = 0;
                    while (i < this.modelElementTypes.length) {
                        this.xmlElementNames[i] = this.createDefaultElementName(this.modelElementTypes[i], xmlNamespaceResolver);
                        ++i;
                    }
                }
            } else {
                if (xmlElementBindingAnnotation.path().length() > 0) {
                    this.path = new XmlPath(xmlElementBindingAnnotation.path(), xmlNamespaceResolver);
                }
                XmlElementBinding.Mapping[] mappings = xmlElementBindingAnnotation.mappings();
                this.xmlElementNames = new QName[this.modelElementTypes.length];
                int i = 0;
                while (i < this.modelElementTypes.length) {
                    ElementType type = this.modelElementTypes[i];
                    XmlElementBinding.Mapping[] mappingArray = mappings;
                    int n = mappings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        XmlElementBinding.Mapping mapping = mappingArray[n2];
                        if (mapping.type() == type.getModelElementClass()) {
                            String mappingElementName = mapping.element().trim();
                            if (mappingElementName.length() == 0) {
                                throw new RuntimeException(mustSpecifyElementNameMsg.text());
                            }
                            this.xmlElementNames[i] = XmlUtil.createQualifiedName(mappingElementName, xmlNamespaceResolver);
                            break;
                        }
                        ++n2;
                    }
                    if (this.xmlElementNames[i] == null) {
                        this.xmlElementNames[i] = this.createDefaultElementName(type, xmlNamespaceResolver);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            String msg = failure.format(new Object[]{element.type().getSimpleName(), property.name(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    protected QName createDefaultElementName(ElementType type, XmlNamespaceResolver xmlNamespaceResolver) {
        return XmlUtil.createDefaultElementName(type);
    }

    public ElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        QName xmlElementName = XmlUtil.createQualifiedName(xmlElement.getDomNode());
        String xmlElementNamespace = xmlElementName.getNamespaceURI();
        int i = 0;
        while (i < this.xmlElementNames.length) {
            if (XmlUtil.equal(this.xmlElementNames[i], xmlElementName, xmlElementNamespace)) {
                return this.modelElementTypes[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    protected Object readUnderlyingObject() {
        XmlElement parent = this.parent(false);
        if (parent != null) {
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
                if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
                return element;
            }
        }
        return null;
    }

    protected Object createUnderlyingObject(ElementType type) {
        XmlElement parent;
        XmlElement base = this.base(false);
        if (base != null && (parent = this.parent(false)) != null) {
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
                if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
                element.remove();
            }
        }
        parent = this.parent(true);
        QName xmlElementName = this.xmlElementNames[MiscUtil.indexOf((Object[])this.modelElementTypes, (Object)type)];
        if (xmlElementName.getNamespaceURI().equals("")) {
            xmlElementName = new QName(parent.getNamespace(), xmlElementName.getLocalPart());
        }
        return parent.getChildElement(xmlElementName, true);
    }

    protected Resource createResource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
        return new ChildXmlResource(parentXmlResource, xmlElement);
    }

    public void remove() {
        XmlElement parent;
        XmlElement base = this.base(false);
        if (base != null && (parent = this.parent(false)) != null) {
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
                if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
                element.remove();
            }
            if (parent != base && parent.isEmpty()) {
                base.removeChildNode(this.path);
            }
        }
    }

    protected XmlElement parent(boolean createIfNecessary) {
        XmlElement parent = this.base(createIfNecessary);
        if (parent != null && this.path != null) {
            parent = (XmlElement)parent.getChildNode(this.path, createIfNecessary);
        }
        return parent;
    }

    protected XmlElement base(boolean createIfNecessary) {
        XmlResource resource = (XmlResource)this.property().element().resource();
        return resource.getXmlElement(createIfNecessary);
    }

    public void dispose() {
        super.dispose();
        if (this.possibleTypesService != null) {
            this.possibleTypesService.detach(this.possibleTypesServiceListener);
        }
    }
}

