/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.ui.PlatformUI;

public class SystemViewDecoratingStyledCellLabelProvider
extends DecoratingStyledCellLabelProvider
implements IPropertyChangeListener,
ILabelProvider {
    public SystemViewDecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator) {
        this(labelProvider, decorator, DecorationContext.DEFAULT_CONTEXT);
    }

    public SystemViewDecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
        super(labelProvider, decorator != null ? decorator : PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), decorationContext);
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.setOwnerDrawEnabled(PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS"));
        super.initialize(viewer, column);
    }

    public void dispose() {
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        PlatformUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected final ColumnViewer getColumnViewer() {
        return this.getViewer();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event == null) {
            return;
        }
        boolean doRefresh = false;
        doRefresh |= event.getProperty().equals("USE_COLORED_LABELS");
        if (!(doRefresh |= event.getProperty().equals("DECORATIONS_COLOR")) || !PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().getDisplay() == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (SystemViewDecoratingStyledCellLabelProvider.this.getColumnViewer() == null) {
                    return;
                }
                boolean useColouredLabels = PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS");
                if (SystemViewDecoratingStyledCellLabelProvider.this.isOwnerDrawEnabled() != useColouredLabels) {
                    SystemViewDecoratingStyledCellLabelProvider.this.setOwnerDrawEnabled(useColouredLabels);
                    SystemViewDecoratingStyledCellLabelProvider.this.getColumnViewer().refresh();
                } else if (useColouredLabels) {
                    SystemViewDecoratingStyledCellLabelProvider.this.getColumnViewer().refresh();
                }
            }
        });
    }
}

