/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.platform;

import org.eclipse.reddeer.common.platform.OS;

public final class RunningPlatform {
    private static final String CURRENT_OS = System.getProperty("os.name").toLowerCase();

    private RunningPlatform() {
    }

    public static boolean isOperationSystem(OS os) {
        boolean result = false;
        if (os.equals((Object)OS.WINDOWS)) {
            result = RunningPlatform.isWindows();
        } else if (os.equals((Object)OS.MACOSX)) {
            result = RunningPlatform.isOSX();
        } else if (os.equals((Object)OS.LINUX)) {
            result = !RunningPlatform.isOSX() && !RunningPlatform.isWindows();
        }
        return result;
    }

    public static boolean isWindows() {
        return CURRENT_OS.startsWith("win");
    }

    public static boolean isOSX() {
        return CURRENT_OS.startsWith("mac");
    }

    public static boolean isLinux() {
        return CURRENT_OS.startsWith("linux");
    }
}

