/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.poll;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.NewsRcpPreferences;
import org.eclipse.recommenders.news.api.poll.INewsPollingService;
import org.eclipse.recommenders.news.api.poll.PollingPolicy;
import org.eclipse.recommenders.news.api.poll.PollingRequest;

public class PollFeedsJob
extends Job {
    private final boolean periodic;
    private final NewsRcpPreferences preferences;
    private final INewsPollingService pollingService;
    private final IEventBroker eventBroker;

    public PollFeedsJob(String name, boolean periodic, NewsRcpPreferences preferences, INewsPollingService pollingService, IEventBroker eventBroker) {
        super(name);
        this.periodic = periodic;
        this.preferences = preferences;
        this.pollingService = pollingService;
        this.eventBroker = eventBroker;
        this.setSystem(true);
        this.setUser(false);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.periodic && this.preferences.isEnabled()) {
            this.schedule(TimeUnit.MINUTES.toMillis(this.preferences.getPollingInterval()));
        }
        List<FeedDescriptor> feeds = this.preferences.getFeedDescriptors();
        ArrayList<PollingRequest> requests = new ArrayList<PollingRequest>();
        for (FeedDescriptor feed : feeds) {
            if (!feed.isEnabled()) continue;
            PollingPolicy policy = this.periodic ? PollingPolicy.every((long)feed.getPollingInterval(), (TimeUnit)TimeUnit.MINUTES) : PollingPolicy.always();
            PollingRequest request = new PollingRequest(feed.getUri(), policy);
            requests.add(request);
        }
        Collection results = this.pollingService.poll(requests, monitor);
        this.eventBroker.post("org_eclipse_recommenders_news/pollingResults", (Object)results);
        return Status.OK_STATUS;
    }
}

