/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.news.impl.poll;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.recommenders.internal.news.impl.poll.Proxies;
import org.eclipse.recommenders.news.impl.poll.IDownloadService;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DefaultDownloadService
implements IDownloadService {
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final long SOCKET_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private final String userAgent;
    private final Executor executor = Executor.newInstance();
    private final Path downloadLocation;

    public DefaultDownloadService() {
        this(DefaultDownloadService.getStateLocation().resolve("downloads"));
    }

    @VisibleForTesting
    DefaultDownloadService(Path downloadLocation) {
        this.downloadLocation = downloadLocation;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        String symbolicName = bundle.getSymbolicName();
        String version = bundle.getVersion().toString();
        this.userAgent = String.valueOf(symbolicName) + '/' + version;
    }

    private static Path getStateLocation() {
        Bundle bundle = FrameworkUtil.getBundle(DefaultDownloadService.class);
        return Platform.getStateLocation((Bundle)bundle).toFile().toPath();
    }

    @Override
    public InputStream download(URI uri, @Nullable IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            String fileName = this.mangleUri(uri);
            Path targetPath = this.downloadLocation.resolve(fileName);
            this.doDownload(uri, fileName, targetPath, progress.newChild(1));
            InputStream inputStream = Files.newInputStream(targetPath, new OpenOption[0]);
            return inputStream;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void doDownload(URI uri, String fileName, Path targetFile, SubMonitor monitor) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 3[TRYBLOCK], 2[TRYBLOCK], 11[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateLastModifiedTime(Path targetFile) throws IOException {
        try {
            Files.setLastModifiedTime(targetFile, FileTime.fromMillis(System.currentTimeMillis()));
        }
        catch (IOException e) {
            try {
                Files.createFile(targetFile, new FileAttribute[0]);
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    private String mangleUri(URI uri) {
        try {
            return URLEncoder.encode(uri.toASCIIString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(uri.toString(), e);
        }
    }

    @Nullable
    private InputStream openWebResourceAsStream(URI uri, SubMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            Response response;
            HttpResponse returnResponse;
            StatusLine statusLine;
            Request request = Request.Get((URI)uri).viaProxy(Proxies.getProxyHost(uri)).userAgent(this.userAgent).connectTimeout((int)CONNECTION_TIMEOUT).staleConnectionCheck(true).socketTimeout((int)SOCKET_TIMEOUT);
            try {
                Date lastAttemptDate = this.getLastAttemptDate(uri);
                if (lastAttemptDate != null) {
                    request.setIfModifiedSince(lastAttemptDate);
                }
            }
            catch (IOException iOException) {}
            if ((statusLine = (returnResponse = (response = Proxies.proxyAuthentication(this.executor, uri).execute(request)).returnResponse()).getStatusLine()) == null) {
                throw new IOException();
            }
            if (statusLine.getStatusCode() >= 400) {
                throw new IOException(statusLine.getReasonPhrase());
            }
            if (statusLine.getStatusCode() == 304) {
                return null;
            }
            HttpEntity entity = returnResponse.getEntity();
            if (entity == null || entity.getContentLength() == 0L) {
                throw new IOException("Empty representation");
            }
            InputStream inputStream = entity.getContent();
            return inputStream;
        }
        finally {
            progress.worked(1);
        }
    }

    @Override
    @Nullable
    public InputStream read(URI uri) throws IOException {
        String fileName = this.mangleUri(uri);
        Path targetPath = this.downloadLocation.resolve(fileName);
        try {
            if (Files.size(targetPath) == 0L) {
                throw new IOException("Empty representation");
            }
            return Files.newInputStream(targetPath, new OpenOption[0]);
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
        catch (IOException e) {
            throw e;
        }
    }

    @Override
    @Nullable
    public Date getLastAttemptDate(URI uri) throws IOException {
        String fileName = this.mangleUri(uri);
        Path targetPath = this.downloadLocation.resolve(fileName);
        try {
            return new Date(Files.getLastModifiedTime(targetPath, new LinkOption[0]).toMillis());
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
        catch (IOException e) {
            throw e;
        }
    }
}

