/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.io.jbif;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.io.IBayesNetReader;

public class JayesBifReader
implements IBayesNetReader {
    private InputStream in;

    public JayesBifReader(InputStream str) {
        this.in = str;
    }

    @Override
    public BayesNet read() throws IOException {
        return this.read(IOUtils.toByteArray((InputStream)this.in));
    }

    private BayesNet read(byte[] array) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        try {
            return this.readBayesNet(buffer);
        }
        catch (RuntimeException e) {
            throw new IOException("Malformed data", e);
        }
    }

    private BayesNet readBayesNet(ByteBuffer buffer) throws IOException {
        BayesNet bayesNet = new BayesNet();
        this.readHeader(buffer);
        bayesNet.setName(this.readName(buffer));
        int nrNodes = buffer.getInt();
        int i = 0;
        while (i < nrNodes) {
            this.readNodeDeclaration(bayesNet, buffer);
            ++i;
        }
        i = 0;
        while (i < nrNodes) {
            this.readNodeDefinition(bayesNet, bayesNet.getNode(i), buffer);
            ++i;
        }
        return bayesNet;
    }

    private void readHeader(ByteBuffer buffer) throws IOException {
        int magicNumber = buffer.getInt();
        if (magicNumber != -1166124257) {
            throw new IOException("Wrong magic number: " + Integer.toHexString(magicNumber).toUpperCase());
        }
        int formatVersion = buffer.getInt();
        if (formatVersion != 1) {
            throw new IOException("Wrong JBIF format version: " + formatVersion);
        }
    }

    private String readName(ByteBuffer buffer) {
        int byteCount = buffer.getShort() & 0xFFFF;
        byte[] bytes = new byte[byteCount];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private void readNodeDeclaration(BayesNet bayesNet, ByteBuffer buffer) {
        BayesNode node = bayesNet.createNode(this.readName(buffer));
        int outcomeCount = buffer.getInt();
        String[] outcomes = new String[outcomeCount];
        int i = 0;
        while (i < outcomeCount) {
            outcomes[i] = this.readName(buffer);
            ++i;
        }
        node.addOutcomes(outcomes);
    }

    private void readNodeDefinition(BayesNet bayesNet, BayesNode node, ByteBuffer buffer) throws IOException {
        node.setParents(this.readParents(bayesNet, buffer));
        node.setProbabilities(this.readCpt(buffer));
    }

    private List<BayesNode> readParents(BayesNet bayesNet, ByteBuffer buffer) throws IOException {
        int parentCount = buffer.get() & 0xFF;
        int[] parentIds = new int[parentCount];
        buffer.asIntBuffer().get(parentIds);
        buffer.position(buffer.position() + parentIds.length * 4);
        ArrayList<BayesNode> parents = new ArrayList<BayesNode>(parentCount);
        int[] nArray = parentIds;
        int n = parentIds.length;
        int n2 = 0;
        while (n2 < n) {
            int parentId = nArray[n2];
            parents.add(bayesNet.getNode(parentId));
            ++n2;
        }
        return parents;
    }

    private double[] readCpt(ByteBuffer buffer) throws IOException {
        int entryCount = buffer.getInt();
        double[] probabilities = new double[entryCount];
        buffer.asDoubleBuffer().get(probabilities);
        buffer.position(buffer.position() + probabilities.length * 8);
        return probabilities;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

