/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIConstants;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.actions.OpenFunctionInvocationStatisticsAction;
import org.eclipse.php.profile.ui.dialogs.FiltersDialog;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilter;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFiltersRegistry;
import org.eclipse.php.profile.ui.views.ExecutionStatisticsView;
import org.eclipse.php.profile.ui.views.TreeElement;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class ExecutionStatisticsActionGroup
extends ActionGroup {
    private static final String GROUP_KEY = "ExecutionStatisticsActionGroup.group";
    ExecutionStatisticsView fView;
    private IPreferenceStore fStore;
    private CollapseAllAction fCollapseAllAction;
    private ExpandAllAction fExpandAllAction;
    private ShowAsPersentageAction fShowAsPercentageAction;
    private GroupByFileAction fGroupByFileAction;
    private GroupByClassAction fGroupByClassAction;
    private GroupByFunctionAction fGroupByFunctionAction;
    private OpenFunctionInvocationStatisticsAction fOpenFunctionInvocationStatisticsAction;
    private FilterAction fFilterAction;

    public ExecutionStatisticsActionGroup(ExecutionStatisticsView view) {
        this.fView = view;
        this.fStore = ProfilerUiPlugin.getDefault().getPreferenceStore();
        this.fExpandAllAction = new ExpandAllAction();
        this.fCollapseAllAction = new CollapseAllAction();
        this.fShowAsPercentageAction = new ShowAsPersentageAction();
        this.fGroupByFileAction = new GroupByFileAction();
        this.fGroupByClassAction = new GroupByClassAction();
        this.fGroupByFunctionAction = new GroupByFunctionAction();
        this.fOpenFunctionInvocationStatisticsAction = new OpenFunctionInvocationStatisticsAction(this.fView);
        this.fFilterAction = new FilterAction();
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IAction)this.fFilterAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.fExpandAllAction);
        toolbarManager.add((IAction)this.fCollapseAllAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.fShowAsPercentageAction);
        toolbarManager.add((IContributionItem)new Separator(GROUP_KEY));
        toolbarManager.appendToGroup(GROUP_KEY, (IAction)this.fGroupByFileAction);
        toolbarManager.appendToGroup(GROUP_KEY, (IAction)this.fGroupByClassAction);
        toolbarManager.appendToGroup(GROUP_KEY, (IAction)this.fGroupByFunctionAction);
        toolbarManager.add((IContributionItem)new Separator("additions"));
        this.updateGroups();
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.fView.getViewer().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            TreeElement element = (TreeElement)((IStructuredSelection)selection).getFirstElement();
            Object data = element.getData();
            if (data instanceof ProfilerFunctionData) {
                menu.add((IAction)this.fOpenFunctionInvocationStatisticsAction);
            } else if (data instanceof ProfilerFileData) {
                ((ProfilerFileData)data).getCodeCoverageData();
            }
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void updateGroups() {
        int groupBy = this.fStore.getInt("executionViewGroupBy");
        this.fGroupByFileAction.setChecked(groupBy == ProfilerUIConstants.GROUP_BY_FILE);
        this.fGroupByClassAction.setChecked(groupBy == ProfilerUIConstants.GROUP_BY_CLASS);
        this.fGroupByFunctionAction.setChecked(groupBy == ProfilerUIConstants.GROUP_BY_FUNCTION);
    }

    class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            super(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_1"));
            this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_1"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_1"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_COLLAPSE_ALL"));
        }

        public void run() {
            BusyIndicator.showWhile((Display)ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ((CollapseAllAction)CollapseAllAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(false);
                    ((CollapseAllAction)CollapseAllAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().collapseAll();
                    ((CollapseAllAction)CollapseAllAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(true);
                    ((CollapseAllAction)CollapseAllAction.this).ExecutionStatisticsActionGroup.this.fView.storeExpandedElements();
                }
            });
        }
    }

    class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            super(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_2"));
            this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_2"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_2"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_EXPAND_ALL"));
        }

        public void run() {
            BusyIndicator.showWhile((Display)ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ((ExpandAllAction)ExpandAllAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(false);
                    ((ExpandAllAction)ExpandAllAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().expandAll();
                    ((ExpandAllAction)ExpandAllAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(true);
                    ((ExpandAllAction)ExpandAllAction.this).ExecutionStatisticsActionGroup.this.fView.storeExpandedElements();
                }
            });
        }
    }

    class FilterAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private ExecutionStatisticsFilter[] fFilters;
        private IPreferenceStore fPreferenceStore;
        private ExecutionStatisticsFilter fNoFilter;

        public FilterAction() {
            super(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_6"), 4);
            this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_6"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_6"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_FILTER"));
            this.setMenuCreator(this);
            this.fPreferenceStore = ProfilerUiPlugin.getDefault().getPreferenceStore();
            this.fFilters = ExecutionStatisticsFiltersRegistry.getFilters();
            this.fNoFilter = new ExecutionStatisticsFilter();
            this.fNoFilter.setName("");
        }

        public void run() {
            this.editFilters();
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
        }

        private void removeOldFilters() {
            ViewerFilter[] filters = ExecutionStatisticsActionGroup.this.fView.getViewer().getFilters();
            int i = 0;
            while (i < filters.length) {
                if (filters[i] instanceof ExecutionStatisticsFilter) {
                    ExecutionStatisticsActionGroup.this.fView.getViewer().removeFilter(filters[i]);
                }
                ++i;
            }
        }

        private void editFilters() {
            FiltersDialog dialog = new FiltersDialog(ExecutionStatisticsActionGroup.this.fView.getSite().getShell());
            if (dialog.open() == 0) {
                this.fFilters = dialog.getFilters();
            }
        }

        public Menu getMenu(Control parent) {
            ActionContributionItem item;
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            int i = 0;
            while (i < this.fFilters.length) {
                item = new ActionContributionItem((IAction)new ApplyFilterAction(this.fFilters[i]));
                item.fill(this.fMenu, -1);
                ++i;
            }
            item = new ActionContributionItem((IAction)new ApplyFilterAction(this.fNoFilter, PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup.7")));
            item.fill(this.fMenu, -1);
            new Separator().fill(this.fMenu, -1);
            item = new ActionContributionItem((IAction)new EditFiltersAction());
            item.fill(this.fMenu, -1);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        class ApplyFilterAction
        extends Action {
            private ExecutionStatisticsFilter fFilter;

            public ApplyFilterAction(ExecutionStatisticsFilter filter) {
                this(filter, filter.getName());
            }

            public ApplyFilterAction(ExecutionStatisticsFilter filter, String filterName) {
                super("  " + filterName, 8);
                this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup.5"));
                this.setToolTipText(filterName);
                this.fFilter = filter;
                if (this.fFilter.getName().equals(FilterAction.this.fPreferenceStore.getString("executionStatisticsSelectedFilter"))) {
                    this.setChecked(true);
                }
            }

            public void run() {
                FilterAction.this.removeOldFilters();
                if (this.fFilter.getName().length() > 0) {
                    ((FilterAction)FilterAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().addFilter((ViewerFilter)this.fFilter);
                }
                FilterAction.this.fPreferenceStore.setValue("executionStatisticsSelectedFilter", this.fFilter.getName());
            }
        }

        class EditFiltersAction
        extends Action {
            public EditFiltersAction() {
                super(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup.0"));
                this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup.1"));
                this.setToolTipText(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup.2"));
                this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_FILTER"));
            }

            public void run() {
                FilterAction.this.editFilters();
            }
        }
    }

    class GroupByClassAction
    extends Action {
        public GroupByClassAction() {
            super(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_5"), 2);
            this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_5"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_5"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_GROUP_BY_CLASS"));
        }

        public void run() {
            if (this.isChecked()) {
                ExecutionStatisticsActionGroup.this.fStore.setValue("executionViewGroupBy", ProfilerUIConstants.GROUP_BY_CLASS);
                BusyIndicator.showWhile((Display)ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((GroupByClassAction)GroupByClassAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(false);
                        ((GroupByClassAction)GroupByClassAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().refresh();
                        ((GroupByClassAction)GroupByClassAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(true);
                        ((GroupByClassAction)GroupByClassAction.this).ExecutionStatisticsActionGroup.this.fView.restoreExpandedElements();
                    }
                });
            }
            ExecutionStatisticsActionGroup.this.updateGroups();
        }
    }

    class GroupByFileAction
    extends Action {
        public GroupByFileAction() {
            super(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_3"), 2);
            this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_3"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_3"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_GROUP_BY_FILE"));
        }

        public void run() {
            if (this.isChecked()) {
                ExecutionStatisticsActionGroup.this.fStore.setValue("executionViewGroupBy", ProfilerUIConstants.GROUP_BY_FILE);
                BusyIndicator.showWhile((Display)ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((GroupByFileAction)GroupByFileAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(false);
                        ((GroupByFileAction)GroupByFileAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().refresh();
                        ((GroupByFileAction)GroupByFileAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(true);
                        ((GroupByFileAction)GroupByFileAction.this).ExecutionStatisticsActionGroup.this.fView.restoreExpandedElements();
                    }
                });
            }
            ExecutionStatisticsActionGroup.this.updateGroups();
        }
    }

    class GroupByFunctionAction
    extends Action {
        public GroupByFunctionAction() {
            super(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_4"), 2);
            this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_4"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_4"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_GROUP_BY_FUNCTION"));
        }

        public void run() {
            if (this.isChecked()) {
                ExecutionStatisticsActionGroup.this.fStore.setValue("executionViewGroupBy", ProfilerUIConstants.GROUP_BY_FUNCTION);
                BusyIndicator.showWhile((Display)ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((GroupByFunctionAction)GroupByFunctionAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(false);
                        ((GroupByFunctionAction)GroupByFunctionAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().refresh();
                        ((GroupByFunctionAction)GroupByFunctionAction.this).ExecutionStatisticsActionGroup.this.fView.getViewer().getControl().setRedraw(true);
                        ((GroupByFunctionAction)GroupByFunctionAction.this).ExecutionStatisticsActionGroup.this.fView.restoreExpandedElements();
                    }
                });
            }
            ExecutionStatisticsActionGroup.this.updateGroups();
        }
    }

    class ShowAsPersentageAction
    extends Action {
        public ShowAsPersentageAction() {
            super(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_0"), 2);
            this.setDescription(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_0"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionStatisticsActionGroup_0"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_PERCENTAGE"));
            this.setChecked(ExecutionStatisticsActionGroup.this.fStore.getBoolean("executionViewShowAsPercentage"));
        }

        public void run() {
            final TreeViewer viewer = ExecutionStatisticsActionGroup.this.fView.getViewer();
            boolean on = this.isChecked();
            ExecutionStatisticsActionGroup.this.fStore.setValue("executionViewShowAsPercentage", on);
            BusyIndicator.showWhile((Display)viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    viewer.getControl().setRedraw(false);
                    viewer.refresh();
                    viewer.getControl().setRedraw(true);
                }
            });
        }
    }
}

