/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.AnonymousClassInstanceType;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;

public class InstanceCreationEvaluator
extends GoalEvaluator {
    private IEvaluatedType result;

    public InstanceCreationEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        ExpressionTypeGoal typedGoal = (ExpressionTypeGoal)this.goal;
        ClassInstanceCreation expression = (ClassInstanceCreation)typedGoal.getExpression();
        if (expression.getAnonymousClassDeclaration() != null && typedGoal.getContext() instanceof ISourceModuleContext) {
            this.result = new AnonymousClassInstanceType(((ISourceModuleContext)typedGoal.getContext()).getSourceModule(), expression.getAnonymousClassDeclaration());
            return IGoal.NO_GOALS;
        }
        Expression className = expression.getClassName();
        if (className instanceof TypeReference) {
            if (this.isSelf((TypeReference)className) && this.goal.getContext() instanceof MethodContext) {
                MethodContext methodContext = (MethodContext)this.goal.getContext();
                this.result = methodContext.getInstanceType();
                return IGoal.NO_GOALS;
            }
            return new IGoal[]{new ExpressionTypeGoal(this.goal.getContext(), (ASTNode)className)};
        }
        this.result = UnknownType.INSTANCE;
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        this.result = (IEvaluatedType)result;
        return IGoal.NO_GOALS;
    }

    private boolean isSelf(TypeReference className) {
        String name = className.getName();
        if (this.goal.getContext() instanceof ISourceModuleContext && PHPVersion.PHP5_4.isLessThan(ProjectOptions.getPHPVersion((IModelElement)((ISourceModuleContext)this.goal.getContext()).getSourceModule()))) {
            name = name.toLowerCase();
        }
        return "self".equals(name);
    }
}

