/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.ArrayKeyContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.language.PHPVariables;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.FakeField;

public class BuiltinArrayKeysStrategy
extends AbstractCompletionStrategy {
    protected static final String[] SERVER_VARS = new String[]{"DOCUMENT_ROOT", "GATEWAY_INTERFACE", "HTTP_ACCEPT", "HTTP_ACCEPT_ENCODING", "HTTP_ACCEPT_LANGUAGE", "HTTP_CONNECTION", "HTTP_HOST", "HTTP_USER_AGENT", "PATH", "PATH_TRANSLATED", "PHP_SELF", "QUERY_STRING", "REMOTE_ADDR", "REMOTE_PORT", "REQUEST_METHOD", "REQUEST_TIME", "REQUEST_URI", "SCRIPT_FILENAME", "SCRIPT_NAME", "SERVER_ADDR", "SERVER_ADMIN", "SERVER_NAME", "SERVER_PORT", "SERVER_PROTOCOL", "SERVER_SIGNATURE", "SERVER_SOFTWARE"};
    protected static final String[] SESSION_VARS = new String[]{"SID"};

    public BuiltinArrayKeysStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public BuiltinArrayKeysStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof ArrayKeyContext)) {
            return;
        }
        ArrayKeyContext arrayContext = (ArrayKeyContext)context;
        CompletionRequestor requestor = arrayContext.getCompletionRequestor();
        String arrayVarName = arrayContext.getArrayVarName();
        String prefix = arrayContext.getPrefix();
        int extraObject = 1;
        if (!arrayContext.hasQuotes()) {
            extraObject |= 0x100;
        }
        if (arrayVarName.equals("$_SERVER") || arrayVarName.equals("$HTTP_SERVER_VARS")) {
            this.reportVariables(reporter, arrayContext, SERVER_VARS, prefix, extraObject);
        } else if (arrayVarName.equals("$_SESSION") || arrayVarName.equals("$HTTP_SESSION_VARS")) {
            this.reportVariables(reporter, arrayContext, SESSION_VARS, prefix, extraObject);
        } else if (arrayVarName.equals("$GLOBALS")) {
            ISearchEngine.MatchRule matchRule = ISearchEngine.MatchRule.PREFIX;
            if (requestor.isContextInformationMode()) {
                matchRule = ISearchEngine.MatchRule.EXACT;
            }
            IDLTKSearchScope scope = this.createSearchScope();
            IField[] elements = PHPModelAccess.getDefault().findFields("$" + prefix, matchRule, 8192, 2, scope, null);
            ArrayList<IField> list = new ArrayList<IField>();
            if (!prefix.startsWith("$")) {
                elements = PHPModelAccess.getDefault().findFields("$" + prefix, matchRule, 8192, 2, scope, null);
                list.addAll(Arrays.asList(elements));
                elements = list.toArray(new IField[list.size()]);
            }
            ISourceRange replaceRange = this.getReplacementRange(arrayContext);
            IField[] iFieldArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IField element;
                IField field = element = iFieldArray[n2];
                try {
                    ISourceRange sourceRange = field.getSourceRange();
                    FakeField fakeField = new FakeField((ModelElement)field.getParent(), field.getElementName().substring(1), sourceRange.getOffset(), sourceRange.getLength());
                    reporter.reportField((IField)fakeField, "", replaceRange, true, 0, (Object)extraObject);
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
                ++n2;
            }
            PHPVersion phpVersion = arrayContext.getPHPVersion();
            this.reportVariables(reporter, arrayContext, PHPVariables.getVariables(phpVersion), prefix, true, extraObject);
        }
    }

    protected void reportVariables(ICompletionReporter reporter, ArrayKeyContext context, String[] variables, String prefix, int extraObject) throws BadLocationException {
        this.reportVariables(reporter, context, variables, prefix, false, extraObject);
    }

    protected void reportVariables(ICompletionReporter reporter, ArrayKeyContext context, String[] variables, String prefix, boolean removeDollar, int extraObject) throws BadLocationException {
        CompletionRequestor requestor = context.getCompletionRequestor();
        ISourceRange replaceRange = this.getReplacementRange(context);
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            if (removeDollar) {
                variable = variable.substring(1);
            }
            if (variable.startsWith(prefix) && (!requestor.isContextInformationMode() || variable.length() == prefix.length())) {
                reporter.reportField((IField)new FakeField((ModelElement)context.getSourceModule(), variable, 0, 0), "", replaceRange, false, 0, (Object)extraObject);
            }
            ++n2;
        }
    }
}

