/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.browser;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.photran.internal.core.vpg.eclipse.EclipseVPG;
import org.eclipse.photran.internal.ui.browser.AnnotationsTab;
import org.eclipse.photran.internal.ui.browser.DependenciesTab;
import org.eclipse.photran.internal.ui.browser.EdgesTab;
import org.eclipse.photran.internal.ui.browser.Messages;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.Workbench;

public class VPGBrowser {
    private EclipseVPG vpg;
    private ArrayList<String> fileNameArray;
    private Shell shell;
    private SashForm sashForm;
    private Composite composite;
    private Text fileNameTextBox;
    private List fileList;
    private TabFolder tabFolder;
    private DependenciesTab dependenciesTab;
    private EdgesTab edgesTab;
    private AnnotationsTab annotationsTab;

    public VPGBrowser(EclipseVPG vpg) {
        this.vpg = vpg;
        this.createShell();
        this.createSashForm();
        this.createComposite();
        this.createFileTextField();
        this.createList();
        this.createTabFolder();
        this.listAllFiles();
    }

    private void createShell() {
        this.shell = new Shell(Workbench.getInstance().getDisplay());
        this.shell.setText(Messages.VPGBrowser_WindowTitle);
        this.centerShellInDisplay();
        this.closeShellWhenEscapeIsPressed();
        this.shell.setLayout((Layout)new GridLayout());
    }

    private void centerShellInDisplay() {
        Rectangle monitor = this.shell.getDisplay().getPrimaryMonitor().getBounds();
        this.shell.setSize(monitor.width * 3 / 4, monitor.height * 3 / 4);
        Rectangle window = this.shell.getBounds();
        int x = monitor.x + (monitor.width - window.width) / 2;
        int y = monitor.y + (monitor.height - window.height) / 2;
        this.shell.setLocation(x, y);
    }

    private void closeShellWhenEscapeIsPressed() {
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        VPGBrowser.this.shell.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
    }

    private void createSashForm() {
        this.sashForm = new SashForm((Composite)this.shell, 256);
        this.sashForm.setLayout((Layout)new FillLayout());
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createComposite() {
        this.composite = new Composite((Composite)this.sashForm, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.composite.setLayout((Layout)gridLayout);
    }

    private void createFileTextField() {
        Label fileNameLabel = new Label(this.composite, 0);
        fileNameLabel.setText(Messages.VPGBrowser_FileNmae);
        this.fileNameTextBox = new Text(this.composite, 2692);
        this.fileNameTextBox.setBounds(100, 100, 100, 100);
        this.fileNameTextBox.setText("");
        this.fileNameTextBox.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fileNameTextBox.addModifyListener((ModifyListener)new TextBoxModifyListener());
    }

    private void showFile(String filename) {
        this.dependenciesTab.showDependentsAndDependencies(filename, this.vpg);
        this.edgesTab.showEdges(filename, this.vpg);
        this.annotationsTab.showAnnotations(filename);
    }

    private void createList() {
        Label fileNameLabel = new Label(this.composite, 0);
        fileNameLabel.setText(Messages.VPGBrowser_Files);
        this.fileList = new List(this.composite, 524);
        this.fileList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fileList.addSelectionListener((SelectionListener)new FileListSelectionListener());
    }

    private void createTabFolder() {
        this.tabFolder = new TabFolder((Composite)this.sashForm, 0);
        TabItem edges = new TabItem(this.tabFolder, 0);
        edges.setText(Messages.VPGBrowser_Edges);
        this.edgesTab = new EdgesTab(edges, this.tabFolder, this.vpg);
        TabItem dependencies = new TabItem(this.tabFolder, 0);
        dependencies.setText(Messages.VPGBrowser_Dependencies);
        this.dependenciesTab = new DependenciesTab(dependencies, this.tabFolder);
        TabItem annotations = new TabItem(this.tabFolder, 0);
        annotations.setText(Messages.VPGBrowser_Annotations);
        this.annotationsTab = new AnnotationsTab(annotations, this.tabFolder, this.vpg);
    }

    public Shell getShell() {
        return this.shell;
    }

    private void listAllFiles() {
        this.fileList.removeAll();
        this.fileNameArray = new ArrayList();
        for (String filename : this.vpg.listAllFilenames()) {
            this.fileList.add(filename);
            this.fileNameArray.add(filename);
        }
    }

    public void open() {
        this.shell.open();
        this.runEventLoop();
    }

    private void runEventLoop() {
        Display display = this.shell.getDisplay();
        while (this.shell != null && !this.shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                e.printStackTrace();
                MessageDialog.openError(null, (String)e.getClass().getName(), (String)this.describe(e));
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }

    private String describe(Throwable e) {
        return String.valueOf(e.getClass().getName()) + ": " + e.getMessage() + "\n\nPlease see the stack trace printed to the console.";
    }

    private final class FileListSelectionListener
    implements SelectionListener {
        private FileListSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = VPGBrowser.this.fileList.getSelectionIndex();
            if (index < 0) {
                return;
            }
            String filename = VPGBrowser.this.fileList.getItem(index);
            VPGBrowser.this.showFile(filename);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private final class TextBoxModifyListener
    implements ModifyListener {
        private TextBoxModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (VPGBrowser.this.fileNameTextBox.getText().length() == 0) {
                VPGBrowser.this.listAllFiles();
            } else {
                this.listFilteredFiles();
            }
        }

        private void listFilteredFiles() {
            VPGBrowser.this.fileList.removeAll();
            int i = 0;
            while (i < VPGBrowser.this.fileNameArray.size()) {
                int substringIndex = ((String)VPGBrowser.this.fileNameArray.get(i)).toLowerCase().indexOf(VPGBrowser.this.fileNameTextBox.getText().toLowerCase());
                if (substringIndex != -1) {
                    VPGBrowser.this.fileList.add((String)VPGBrowser.this.fileNameArray.get(i));
                }
                ++i;
            }
            if (VPGBrowser.this.fileList.getItemCount() == 1) {
                VPGBrowser.this.fileList.setSelection(0);
                VPGBrowser.this.showFile(VPGBrowser.this.fileList.getItem(0));
            }
        }
    }
}

